/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.log;

import java.util.HashMap;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;

public class LogTools {
    private static final String IHMC_ROOT_LOGGER_NAME = "us.ihmc";
    private static boolean GRANULAR_MODE = false;
    private static boolean GRANULAR_MODE_SET_EXPLICITLY = false;
    private static final HashMap<String, Logger> loggers;
    private static final Logger IHMC_ROOT_LOGGER;

    private static void setLevel(String propertyName, String group) {
        if (System.getProperties().containsKey(propertyName)) {
            String level = System.getProperty(propertyName).trim().toLowerCase();
            if (level.startsWith("fat") || level.startsWith("err")) {
                Configurator.setLevel((String)group, (Level)Level.ERROR);
            } else if (level.startsWith("war")) {
                Configurator.setLevel((String)group, (Level)Level.WARN);
            } else if (level.startsWith("inf")) {
                Configurator.setLevel((String)group, (Level)Level.INFO);
            } else if (level.startsWith("deb")) {
                Configurator.setLevel((String)group, (Level)Level.DEBUG);
            } else if (level.startsWith("tra")) {
                Configurator.setLevel((String)group, (Level)Level.TRACE);
            } else if (level.startsWith("all")) {
                Configurator.setLevel((String)group, (Level)Level.ALL);
            } else if (level.startsWith("off")) {
                Configurator.setLevel((String)group, (Level)Level.OFF);
            }
        }
    }

    private static Logger getLogger(String loggerName) {
        if (!GRANULAR_MODE) {
            throw new RuntimeException("getLogger() should never be called when GRANULAR_MODE = false");
        }
        Logger maybeLogger = loggers.get(loggerName);
        if (maybeLogger != null) {
            return maybeLogger;
        }
        Logger logger = LogManager.getLogger((String)loggerName);
        loggers.put(loggerName, logger);
        return logger;
    }

    private static StackTraceElement origin(int additionalStackTraceHeight) {
        return Thread.currentThread().getStackTrace()[4 + additionalStackTraceHeight];
    }

    private static StackTraceElement origin() {
        return Thread.currentThread().getStackTrace()[4];
    }

    private static String format(StackTraceElement origin, Object message) {
        return LogTools.clickableCoordinatePrefix(origin) + (message == null ? null : message.toString());
    }

    private static String clickableCoordinatePrefix(StackTraceElement origin) {
        return "(" + LogTools.classSimpleName(origin) + ".java:" + origin.getLineNumber() + "): ";
    }

    private static String classSimpleName(StackTraceElement origin) {
        String[] classNameSplit = origin.getClassName().split("\\.");
        return classNameSplit[classNameSplit.length - 1].split("\\$")[0];
    }

    private static String classFromOrigin(StackTraceElement origin) {
        return origin.getClassName().replaceAll("\\$", ".");
    }

    private static void logIfEnabled(Level level, Object message) {
        if (!GRANULAR_MODE) {
            if (IHMC_ROOT_LOGGER.isEnabled(level)) {
                StackTraceElement origin = LogTools.origin();
                IHMC_ROOT_LOGGER.log(level, LogTools.format(origin, message));
            }
        } else {
            StackTraceElement origin = LogTools.origin();
            Logger logger = LogTools.getLogger(LogTools.classFromOrigin(origin));
            if (logger.isEnabled(level)) {
                logger.log(level, LogTools.format(origin, message));
            }
        }
    }

    private static void logIfEnabled(Level level, int additionalStackTraceHeight, Object message) {
        if (!GRANULAR_MODE) {
            if (IHMC_ROOT_LOGGER.isEnabled(level)) {
                StackTraceElement origin = LogTools.origin(additionalStackTraceHeight);
                IHMC_ROOT_LOGGER.log(level, LogTools.format(origin, message));
            }
        } else {
            StackTraceElement origin = LogTools.origin(additionalStackTraceHeight);
            Logger logger = LogTools.getLogger(LogTools.classFromOrigin(origin));
            if (logger.isEnabled(level)) {
                logger.log(level, LogTools.format(origin, message));
            }
        }
    }

    private static void logIfEnabled(Level level, Supplier<?> msgSupplier) {
        if (!GRANULAR_MODE) {
            if (IHMC_ROOT_LOGGER.isEnabled(level)) {
                StackTraceElement origin = LogTools.origin();
                IHMC_ROOT_LOGGER.log(level, LogTools.format(origin, msgSupplier.get()));
            }
        } else {
            StackTraceElement origin = LogTools.origin();
            Logger logger = LogTools.getLogger(LogTools.classFromOrigin(origin));
            if (logger.isEnabled(level)) {
                logger.log(level, LogTools.format(origin, msgSupplier.get()));
            }
        }
    }

    private static void logIfEnabled(Level level, Object message, Supplier<?> msgSupplier) {
        if (!GRANULAR_MODE) {
            if (IHMC_ROOT_LOGGER.isEnabled(level)) {
                StackTraceElement origin = LogTools.origin();
                IHMC_ROOT_LOGGER.log(level, LogTools.format(origin, message), msgSupplier.get());
            }
        } else {
            StackTraceElement origin = LogTools.origin();
            Logger logger = LogTools.getLogger(LogTools.classFromOrigin(origin));
            if (logger.isEnabled(level)) {
                logger.log(level, LogTools.format(origin, message), msgSupplier.get());
            }
        }
    }

    private static void logIfEnabled(Level level, Object message, Object p0) {
        if (!GRANULAR_MODE) {
            if (IHMC_ROOT_LOGGER.isEnabled(level)) {
                StackTraceElement origin = LogTools.origin();
                IHMC_ROOT_LOGGER.log(level, LogTools.format(origin, message), p0);
            }
        } else {
            StackTraceElement origin = LogTools.origin();
            Logger logger = LogTools.getLogger(LogTools.classFromOrigin(origin));
            if (logger.isEnabled(level)) {
                logger.log(level, LogTools.format(origin, message), p0);
            }
        }
    }

    private static void logIfEnabled(Level level, Object message, Object p0, Object p1) {
        if (!GRANULAR_MODE) {
            if (IHMC_ROOT_LOGGER.isEnabled(level)) {
                StackTraceElement origin = LogTools.origin();
                IHMC_ROOT_LOGGER.log(level, LogTools.format(origin, message), p0, p1);
            }
        } else {
            StackTraceElement origin = LogTools.origin();
            Logger logger = LogTools.getLogger(LogTools.classFromOrigin(origin));
            if (logger.isEnabled(level)) {
                logger.log(level, LogTools.format(origin, message), p0, p1);
            }
        }
    }

    private static void logIfEnabled(Level level, Object message, Object p0, Object p1, Object p2) {
        if (!GRANULAR_MODE) {
            if (IHMC_ROOT_LOGGER.isEnabled(level)) {
                StackTraceElement origin = LogTools.origin();
                IHMC_ROOT_LOGGER.log(level, LogTools.format(origin, message), p0, p1, p2);
            }
        } else {
            StackTraceElement origin = LogTools.origin();
            Logger logger = LogTools.getLogger(LogTools.classFromOrigin(origin));
            if (logger.isEnabled(level)) {
                logger.log(level, LogTools.format(origin, message), p0, p1, p2);
            }
        }
    }

    public static Level getLevel() {
        if (!GRANULAR_MODE) {
            return IHMC_ROOT_LOGGER.getLevel();
        }
        StackTraceElement origin = LogTools.origin(-1);
        Logger logger = LogTools.getLogger(LogTools.classFromOrigin(origin));
        return logger.getLevel();
    }

    public static boolean isEnabled(Level level) {
        if (!GRANULAR_MODE) {
            return IHMC_ROOT_LOGGER.isEnabled(level);
        }
        StackTraceElement origin = LogTools.origin(-1);
        Logger logger = LogTools.getLogger(LogTools.classFromOrigin(origin));
        return logger.isEnabled(level);
    }

    public static boolean isEnabled(Level level, int additionalStackTraceHeight) {
        if (!GRANULAR_MODE) {
            return IHMC_ROOT_LOGGER.isEnabled(level);
        }
        StackTraceElement origin = LogTools.origin(-1 + additionalStackTraceHeight);
        Logger logger = LogTools.getLogger(LogTools.classFromOrigin(origin));
        return logger.isEnabled(level);
    }

    public static boolean isFatalEnabled() {
        if (!GRANULAR_MODE) {
            return IHMC_ROOT_LOGGER.isEnabled(Level.FATAL);
        }
        StackTraceElement origin = LogTools.origin(-1);
        Logger logger = LogTools.getLogger(LogTools.classFromOrigin(origin));
        return logger.isEnabled(Level.FATAL);
    }

    public static boolean isFatalEnabled(int additionalStackTraceHeight) {
        if (!GRANULAR_MODE) {
            return IHMC_ROOT_LOGGER.isEnabled(Level.FATAL);
        }
        StackTraceElement origin = LogTools.origin(-1 + additionalStackTraceHeight);
        Logger logger = LogTools.getLogger(LogTools.classFromOrigin(origin));
        return logger.isEnabled(Level.FATAL);
    }

    public static boolean isErrorEnabled() {
        if (!GRANULAR_MODE) {
            return IHMC_ROOT_LOGGER.isEnabled(Level.ERROR);
        }
        StackTraceElement origin = LogTools.origin(-1);
        Logger logger = LogTools.getLogger(LogTools.classFromOrigin(origin));
        return logger.isEnabled(Level.ERROR);
    }

    public static boolean isErrorEnabled(int additionalStackTraceHeight) {
        if (!GRANULAR_MODE) {
            return IHMC_ROOT_LOGGER.isEnabled(Level.ERROR);
        }
        StackTraceElement origin = LogTools.origin(-1 + additionalStackTraceHeight);
        Logger logger = LogTools.getLogger(LogTools.classFromOrigin(origin));
        return logger.isEnabled(Level.ERROR);
    }

    public static boolean isWarnEnabled() {
        if (!GRANULAR_MODE) {
            return IHMC_ROOT_LOGGER.isEnabled(Level.WARN);
        }
        StackTraceElement origin = LogTools.origin(-1);
        Logger logger = LogTools.getLogger(LogTools.classFromOrigin(origin));
        return logger.isEnabled(Level.WARN);
    }

    public static boolean isWarnEnabled(int additionalStackTraceHeight) {
        if (!GRANULAR_MODE) {
            return IHMC_ROOT_LOGGER.isEnabled(Level.WARN);
        }
        StackTraceElement origin = LogTools.origin(-1 + additionalStackTraceHeight);
        Logger logger = LogTools.getLogger(LogTools.classFromOrigin(origin));
        return logger.isEnabled(Level.WARN);
    }

    public static boolean isInfoEnabled() {
        if (!GRANULAR_MODE) {
            return IHMC_ROOT_LOGGER.isEnabled(Level.INFO);
        }
        StackTraceElement origin = LogTools.origin(-1);
        Logger logger = LogTools.getLogger(LogTools.classFromOrigin(origin));
        return logger.isEnabled(Level.INFO);
    }

    public static boolean isInfoEnabled(int additionalStackTraceHeight) {
        if (!GRANULAR_MODE) {
            return IHMC_ROOT_LOGGER.isEnabled(Level.INFO);
        }
        StackTraceElement origin = LogTools.origin(-1 + additionalStackTraceHeight);
        Logger logger = LogTools.getLogger(LogTools.classFromOrigin(origin));
        return logger.isEnabled(Level.INFO);
    }

    public static boolean isDebugEnabled() {
        if (!GRANULAR_MODE) {
            return IHMC_ROOT_LOGGER.isEnabled(Level.DEBUG);
        }
        StackTraceElement origin = LogTools.origin(-1);
        Logger logger = LogTools.getLogger(LogTools.classFromOrigin(origin));
        return logger.isEnabled(Level.DEBUG);
    }

    public static boolean isDebugEnabled(int additionalStackTraceHeight) {
        if (!GRANULAR_MODE) {
            return IHMC_ROOT_LOGGER.isEnabled(Level.DEBUG);
        }
        StackTraceElement origin = LogTools.origin(-1 + additionalStackTraceHeight);
        Logger logger = LogTools.getLogger(LogTools.classFromOrigin(origin));
        return logger.isEnabled(Level.DEBUG);
    }

    public static boolean isTraceEnabled() {
        if (!GRANULAR_MODE) {
            return IHMC_ROOT_LOGGER.isEnabled(Level.TRACE);
        }
        StackTraceElement origin = LogTools.origin(-1);
        Logger logger = LogTools.getLogger(LogTools.classFromOrigin(origin));
        return logger.isEnabled(Level.TRACE);
    }

    public static boolean isTraceEnabled(int additionalStackTraceHeight) {
        if (!GRANULAR_MODE) {
            return IHMC_ROOT_LOGGER.isEnabled(Level.TRACE);
        }
        StackTraceElement origin = LogTools.origin(-1 + additionalStackTraceHeight);
        Logger logger = LogTools.getLogger(LogTools.classFromOrigin(origin));
        return logger.isEnabled(Level.TRACE);
    }

    public static void log(Level level, Object message) {
        LogTools.logIfEnabled(level, message);
    }

    public static void log(Level level, int additionalStackTraceHeight, Object message) {
        LogTools.logIfEnabled(level, additionalStackTraceHeight, message);
    }

    public static void log(Level level, Supplier<?> msgSupplier) {
        LogTools.logIfEnabled(level, msgSupplier);
    }

    public static void log(Level level, Object message, Supplier<?> msgSupplier) {
        LogTools.logIfEnabled(level, message, msgSupplier);
    }

    public static void log(Level level, Object message, Object p0) {
        LogTools.logIfEnabled(level, message, p0);
    }

    public static void log(Level level, Object message, Object p0, Object p1) {
        LogTools.logIfEnabled(level, message, p0, p1);
    }

    public static void log(Level level, Object message, Object p0, Object p1, Object p2) {
        LogTools.logIfEnabled(level, message, p0, p1, p2);
    }

    public static void log(Level level, String message) {
        LogTools.logIfEnabled(level, message);
    }

    public static void log(Level level, String message, Supplier<?> msgSupplier) {
        LogTools.logIfEnabled(level, (Object)message, msgSupplier);
    }

    public static void log(Level level, String message, Object p0) {
        LogTools.logIfEnabled(level, (Object)message, p0);
    }

    public static void log(Level level, String message, Object p0, Object p1) {
        LogTools.logIfEnabled(level, message, p0, p1);
    }

    public static void log(Level level, String message, Object p0, Object p1, Object p2) {
        LogTools.logIfEnabled(level, message, p0, p1, p2);
    }

    public static void fatal(Object message) {
        LogTools.logIfEnabled(Level.FATAL, message);
    }

    public static void fatal(int additionalStackTraceHeight, Object message) {
        LogTools.logIfEnabled(Level.FATAL, additionalStackTraceHeight, message);
    }

    public static void fatal(Supplier<?> msgSupplier) {
        LogTools.logIfEnabled(Level.FATAL, msgSupplier);
    }

    public static void fatal(Object message, Supplier<?> msgSupplier) {
        LogTools.logIfEnabled(Level.FATAL, message, msgSupplier);
    }

    public static void fatal(Object message, Object p0) {
        LogTools.logIfEnabled(Level.FATAL, message, p0);
    }

    public static void fatal(Object message, Object p0, Object p1) {
        LogTools.logIfEnabled(Level.FATAL, message, p0, p1);
    }

    public static void fatal(Object message, Object p0, Object p1, Object p2) {
        LogTools.logIfEnabled(Level.FATAL, message, p0, p1, p2);
    }

    public static void fatal(String message) {
        LogTools.logIfEnabled(Level.FATAL, message);
    }

    public static void fatal(String message, Supplier<?> msgSupplier) {
        LogTools.logIfEnabled(Level.FATAL, (Object)message, msgSupplier);
    }

    public static void fatal(String message, Object p0) {
        LogTools.logIfEnabled(Level.FATAL, (Object)message, p0);
    }

    public static void fatal(String message, Object p0, Object p1) {
        LogTools.logIfEnabled(Level.FATAL, message, p0, p1);
    }

    public static void fatal(String message, Object p0, Object p1, Object p2) {
        LogTools.logIfEnabled(Level.FATAL, message, p0, p1, p2);
    }

    public static void error(Object message) {
        LogTools.logIfEnabled(Level.ERROR, message);
    }

    public static void error(int additionalStackTraceHeight, Object message) {
        LogTools.logIfEnabled(Level.ERROR, additionalStackTraceHeight, message);
    }

    public static void error(Supplier<?> msgSupplier) {
        LogTools.logIfEnabled(Level.ERROR, msgSupplier);
    }

    public static void error(Object message, Supplier<?> msgSupplier) {
        LogTools.logIfEnabled(Level.ERROR, message, msgSupplier);
    }

    public static void error(Object message, Object p0) {
        LogTools.logIfEnabled(Level.ERROR, message, p0);
    }

    public static void error(Object message, Object p0, Object p1) {
        LogTools.logIfEnabled(Level.ERROR, message, p0, p1);
    }

    public static void error(Object message, Object p0, Object p1, Object p2) {
        LogTools.logIfEnabled(Level.ERROR, message, p0, p1, p2);
    }

    public static void error(String message) {
        LogTools.logIfEnabled(Level.ERROR, message);
    }

    public static void error(String message, Supplier<?> msgSupplier) {
        LogTools.logIfEnabled(Level.ERROR, (Object)message, msgSupplier);
    }

    public static void error(String message, Object p0) {
        LogTools.logIfEnabled(Level.ERROR, (Object)message, p0);
    }

    public static void error(String message, Object p0, Object p1) {
        LogTools.logIfEnabled(Level.ERROR, message, p0, p1);
    }

    public static void error(String message, Object p0, Object p1, Object p2) {
        LogTools.logIfEnabled(Level.ERROR, message, p0, p1, p2);
    }

    public static void warn(Object message) {
        LogTools.logIfEnabled(Level.WARN, message);
    }

    public static void warn(int additionalStackTraceHeight, Object message) {
        LogTools.logIfEnabled(Level.WARN, additionalStackTraceHeight, message);
    }

    public static void warn(Supplier<?> msgSupplier) {
        LogTools.logIfEnabled(Level.WARN, msgSupplier);
    }

    public static void warn(Object message, Supplier<?> msgSupplier) {
        LogTools.logIfEnabled(Level.WARN, message, msgSupplier);
    }

    public static void warn(Object message, Object p0) {
        LogTools.logIfEnabled(Level.WARN, message, p0);
    }

    public static void warn(Object message, Object p0, Object p1) {
        LogTools.logIfEnabled(Level.WARN, message, p0, p1);
    }

    public static void warn(Object message, Object p0, Object p1, Object p2) {
        LogTools.logIfEnabled(Level.WARN, message, p0, p1, p2);
    }

    public static void warn(String message) {
        LogTools.logIfEnabled(Level.WARN, message);
    }

    public static void warn(String message, Supplier<?> msgSupplier) {
        LogTools.logIfEnabled(Level.WARN, (Object)message, msgSupplier);
    }

    public static void warn(String message, Object p0) {
        LogTools.logIfEnabled(Level.WARN, (Object)message, p0);
    }

    public static void warn(String message, Object p0, Object p1) {
        LogTools.logIfEnabled(Level.WARN, message, p0, p1);
    }

    public static void warn(String message, Object p0, Object p1, Object p2) {
        LogTools.logIfEnabled(Level.WARN, message, p0, p1, p2);
    }

    public static void info(Object message) {
        LogTools.logIfEnabled(Level.INFO, message);
    }

    public static void info(int additionalStackTraceHeight, Object message) {
        LogTools.logIfEnabled(Level.INFO, additionalStackTraceHeight, message);
    }

    public static void info(Supplier<?> msgSupplier) {
        LogTools.logIfEnabled(Level.INFO, msgSupplier);
    }

    public static void info(Object message, Supplier<?> msgSupplier) {
        LogTools.logIfEnabled(Level.INFO, message, msgSupplier);
    }

    public static void info(Object message, Object p0) {
        LogTools.logIfEnabled(Level.INFO, message, p0);
    }

    public static void info(Object message, Object p0, Object p1) {
        LogTools.logIfEnabled(Level.INFO, message, p0, p1);
    }

    public static void info(Object message, Object p0, Object p1, Object p2) {
        LogTools.logIfEnabled(Level.INFO, message, p0, p1, p2);
    }

    public static void info(String message) {
        LogTools.logIfEnabled(Level.INFO, message);
    }

    public static void info(String message, Supplier<?> msgSupplier) {
        LogTools.logIfEnabled(Level.INFO, (Object)message, msgSupplier);
    }

    public static void info(String message, Object p0) {
        LogTools.logIfEnabled(Level.INFO, (Object)message, p0);
    }

    public static void info(String message, Object p0, Object p1) {
        LogTools.logIfEnabled(Level.INFO, message, p0, p1);
    }

    public static void info(String message, Object p0, Object p1, Object p2) {
        LogTools.logIfEnabled(Level.INFO, message, p0, p1, p2);
    }

    public static void debug(Object message) {
        LogTools.logIfEnabled(Level.DEBUG, message);
    }

    public static void debug(int additionalStackTraceHeight, Object message) {
        LogTools.logIfEnabled(Level.DEBUG, additionalStackTraceHeight, message);
    }

    public static void debug(Supplier<?> msgSupplier) {
        LogTools.logIfEnabled(Level.DEBUG, msgSupplier);
    }

    public static void debug(Object message, Supplier<?> msgSupplier) {
        LogTools.logIfEnabled(Level.DEBUG, message, msgSupplier);
    }

    public static void debug(Object message, Object p0) {
        LogTools.logIfEnabled(Level.DEBUG, message, p0);
    }

    public static void debug(Object message, Object p0, Object p1) {
        LogTools.logIfEnabled(Level.DEBUG, message, p0, p1);
    }

    public static void debug(Object message, Object p0, Object p1, Object p2) {
        LogTools.logIfEnabled(Level.DEBUG, message, p0, p1, p2);
    }

    public static void debug(String message) {
        LogTools.logIfEnabled(Level.DEBUG, message);
    }

    public static void debug(String message, Supplier<?> msgSupplier) {
        LogTools.logIfEnabled(Level.DEBUG, (Object)message, msgSupplier);
    }

    public static void debug(String message, Object p0) {
        LogTools.logIfEnabled(Level.DEBUG, (Object)message, p0);
    }

    public static void debug(String message, Object p0, Object p1) {
        LogTools.logIfEnabled(Level.DEBUG, message, p0, p1);
    }

    public static void debug(String message, Object p0, Object p1, Object p2) {
        LogTools.logIfEnabled(Level.DEBUG, message, p0, p1, p2);
    }

    public static void trace(Object message) {
        LogTools.logIfEnabled(Level.TRACE, message);
    }

    public static void trace(int additionalStackTraceHeight, Object message) {
        LogTools.logIfEnabled(Level.TRACE, additionalStackTraceHeight, message);
    }

    public static void trace(Supplier<?> msgSupplier) {
        LogTools.logIfEnabled(Level.TRACE, msgSupplier);
    }

    public static void trace(Object message, Supplier<?> msgSupplier) {
        LogTools.logIfEnabled(Level.TRACE, message, msgSupplier);
    }

    public static void trace(Object message, Object p0) {
        LogTools.logIfEnabled(Level.TRACE, message, p0);
    }

    public static void trace(Object message, Object p0, Object p1) {
        LogTools.logIfEnabled(Level.TRACE, message, p0, p1);
    }

    public static void trace(Object message, Object p0, Object p1, Object p2) {
        LogTools.logIfEnabled(Level.TRACE, message, p0, p1, p2);
    }

    public static void trace(String message) {
        LogTools.logIfEnabled(Level.TRACE, message);
    }

    public static void trace(String message, Supplier<?> msgSupplier) {
        LogTools.logIfEnabled(Level.TRACE, (Object)message, msgSupplier);
    }

    public static void trace(String message, Object p0) {
        LogTools.logIfEnabled(Level.TRACE, (Object)message, p0);
    }

    public static void trace(String message, Object p0, Object p1) {
        LogTools.logIfEnabled(Level.TRACE, message, p0, p1);
    }

    public static void trace(String message, Object p0, Object p1, Object p2) {
        LogTools.logIfEnabled(Level.TRACE, message, p0, p1, p2);
    }

    static {
        String granular = System.getProperty("log.granular");
        if (granular != null) {
            GRANULAR_MODE_SET_EXPLICITLY = true;
            if (granular.trim().toLowerCase().contains("true")) {
                GRANULAR_MODE = true;
            }
        }
        TreeSet<Object> sortedKeys = new TreeSet<Object>();
        sortedKeys.addAll(System.getProperties().keySet());
        for (Object e : sortedKeys) {
            String stringKey;
            if (!(e instanceof String) || !(stringKey = (String)e).startsWith("log.level")) continue;
            String afterLogLevel = stringKey.substring(9);
            if (afterLogLevel.isEmpty() || afterLogLevel.equals(".")) {
                LogTools.setLevel(stringKey, "");
                LogTools.setLevel(stringKey, IHMC_ROOT_LOGGER_NAME);
                continue;
            }
            if (afterLogLevel.equals(".us.ihmc")) {
                LogTools.setLevel(stringKey, IHMC_ROOT_LOGGER_NAME);
                continue;
            }
            if (!afterLogLevel.startsWith(".")) continue;
            if (!GRANULAR_MODE_SET_EXPLICITLY) {
                GRANULAR_MODE = true;
            }
            LogTools.setLevel(stringKey, afterLogLevel.substring(1));
        }
        loggers = GRANULAR_MODE ? new HashMap() : null;
        Logger logger = IHMC_ROOT_LOGGER = GRANULAR_MODE ? LogTools.getLogger(IHMC_ROOT_LOGGER_NAME) : LogManager.getLogger((String)IHMC_ROOT_LOGGER_NAME);
        if (GRANULAR_MODE) {
            LogTools.info("Granular logging mode enabled. Not realtime safe.");
        }
    }
}

