/*
 * Decompiled with CFR 0.152.
 */
package jme3dae.utilities;

import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import jme3dae.collada14.transformers.PolygonData;
import jme3dae.transformers.ValueTransformer;
import jme3dae.utilities.MeasuringUnit;
import jme3dae.utilities.Tuple2;

public class PolygonArrayTransformer
implements ValueTransformer<Tuple2<MeasuringUnit, PolygonData[]>, Tuple2<Mesh, PolygonData[]>> {
    public static PolygonArrayTransformer create() {
        return new PolygonArrayTransformer();
    }

    private PolygonArrayTransformer() {
    }

    @Override
    public ValueTransformer.TransformedValue<Tuple2<Mesh, PolygonData[]>> transform(Tuple2<MeasuringUnit, PolygonData[]> data) {
        MeasuringUnit unit = data.getA();
        PolygonData[] polygons = data.getB();
        Tuple2<Mesh, PolygonData[]> result = null;
        if (polygons != null && polygons.length > 0) {
            Mesh mesh = null;
            boolean triangles = true;
            int i = 0;
            while (i < polygons.length & triangles) {
                PolygonData polygonData = polygons[i];
                if (polygonData.getVertexCount() != 3) {
                    triangles = false;
                }
                ++i;
            }
            if (!triangles) {
                polygons = this.triangulate(polygons);
            }
            int vcount = polygons.length * 3;
            PolygonData tag = polygons[0];
            Integer vset = tag.getVertexSets().iterator().next();
            mesh = new Mesh();
            this.generatePositionsAndIndices(vcount, tag, vset, polygons, mesh, unit);
            this.generateBinormals(tag, vcount, polygons, mesh);
            this.generateNormals(tag, vcount, polygons, mesh);
            this.generateTangents(tag, vcount, polygons, mesh);
            this.generateTexcoords(tag, vcount, polygons, mesh);
            result = Tuple2.create(mesh, polygons);
        }
        return ValueTransformer.TransformedValue.create(result);
    }

    private void generateTexcoords(PolygonData tag, int vcount, PolygonData[] polygons, Mesh mesh) {
        Set<Integer> texcoordSets = tag.getTexcoordSets();
        if (!texcoordSets.isEmpty()) {
            Integer set = texcoordSets.iterator().next();
            FloatBuffer buffer = BufferUtils.createFloatBuffer((int)(tag.getTexcoordStride(set) * vcount));
            for (int i = 0; i < polygons.length; ++i) {
                PolygonData polygonData = polygons[i];
                polygonData.popTexcoordSet(set, buffer);
            }
            buffer.flip();
            mesh.setBuffer(VertexBuffer.Type.TexCoord, tag.getTexcoordStride(set), buffer);
        }
    }

    private void generateTangents(PolygonData tag, int vcount, PolygonData[] polygons, Mesh mesh) {
        Set<Integer> tangentSets = tag.getTangentSets();
        if (!tangentSets.isEmpty()) {
            Integer set = tangentSets.iterator().next();
            FloatBuffer buffer = BufferUtils.createFloatBuffer((int)(tag.getTangentStride(set) * vcount));
            for (int i = 0; i < polygons.length; ++i) {
                PolygonData polygonData = polygons[i];
                polygonData.popTangentSet(set, buffer);
            }
            buffer.flip();
            mesh.setBuffer(VertexBuffer.Type.Tangent, tag.getTangentStride(set), buffer);
        }
    }

    private void generateNormals(PolygonData tag, int vcount, PolygonData[] polygons, Mesh mesh) {
        Set<Integer> normalSets = tag.getNormalSets();
        if (!normalSets.isEmpty()) {
            Integer set = normalSets.iterator().next();
            FloatBuffer buffer = BufferUtils.createFloatBuffer((int)(tag.getNormalStride(set) * vcount));
            for (int i = 0; i < polygons.length; ++i) {
                PolygonData polygonData = polygons[i];
                polygonData.popNormalSet(set, buffer);
            }
            buffer.flip();
            mesh.setBuffer(VertexBuffer.Type.Normal, tag.getNormalStride(set), buffer);
        }
    }

    private void generateBinormals(PolygonData tag, int vcount, PolygonData[] polygons, Mesh mesh) {
        Set<Integer> binormalSets = tag.getBinormalSets();
        if (!binormalSets.isEmpty()) {
            Integer set = binormalSets.iterator().next();
            FloatBuffer buffer = BufferUtils.createFloatBuffer((int)(tag.getBinormalStride(set) * vcount));
            for (int i = 0; i < polygons.length; ++i) {
                PolygonData polygonData = polygons[i];
                polygonData.popBinormalSet(set, buffer);
            }
            buffer.flip();
            mesh.setBuffer(VertexBuffer.Type.Binormal, tag.getBinormalStride(set), buffer);
        }
    }

    private void generatePositionsAndIndices(int vcount, PolygonData tag, Integer vset, PolygonData[] polygons, Mesh mesh, MeasuringUnit unit) {
        int i;
        FloatBuffer vbuffer = BufferUtils.createFloatBuffer((int)(vcount * tag.getVertexStride(vset)));
        for (i = 0; i < polygons.length; ++i) {
            PolygonData polygonData = polygons[i];
            polygons[i].popVertexSet(vset, vbuffer);
        }
        vbuffer.flip();
        for (i = 0; i < vbuffer.capacity(); ++i) {
            vbuffer.put(i, vbuffer.get(i) * unit.getMeter());
        }
        mesh.setBuffer(VertexBuffer.Type.Position, tag.getVertexStride(vset), vbuffer);
        IntBuffer indices = BufferUtils.createIntBuffer((int)vcount);
        for (int i2 = 0; i2 < vcount; ++i2) {
            indices.put(i2);
        }
        indices.flip();
        mesh.setBuffer(VertexBuffer.Type.Index, 1, indices);
    }

    private PolygonData[] triangulate(PolygonData[] polygons) {
        ArrayList<PolygonData> data = new ArrayList<PolygonData>();
        for (int i = 0; i < polygons.length; ++i) {
            PolygonData polygonData = polygons[i];
            data.addAll(Arrays.asList(polygonData.triangulate()));
        }
        polygons = data.toArray(new PolygonData[data.size()]);
        return polygons;
    }
}

