/*
 * Decompiled with CFR 0.152.
 */
package jme3dae.utilities;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3dae.transformers.ValueTransformer;

public class FloatListTransformer
implements ValueTransformer<String, float[]> {
    public static FloatListTransformer create() {
        return new FloatListTransformer();
    }

    private FloatListTransformer() {
    }

    @Override
    public ValueTransformer.TransformedValue<float[]> transform(String value) {
        float[] data = null;
        value = value.trim();
        value = value.replace('\n', ' ');
        String[] elements = value.trim().split(" ");
        ArrayList<String> es = new ArrayList<String>(elements.length);
        for (String string : elements) {
            if (string.trim().isEmpty()) continue;
            es.add(string);
        }
        if (es.size() > 0) {
            try {
                data = new float[es.size()];
                for (int i = 0; i < es.size(); ++i) {
                    String string = (String)es.get(i);
                    data[i] = Float.parseFloat(string);
                }
            }
            catch (NumberFormatException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "", ex);
                data = null;
            }
        }
        return ValueTransformer.TransformedValue.create(data);
    }
}

