/*
 * Decompiled with CFR 0.152.
 */
package jme3dae.collada14.transformers;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import jme3dae.utilities.Tuple2;
import jme3dae.utilities.Vertex;
import jme3dae.utilities.VertexSkinningData;

public class PolygonData {
    private final int vertexCount;
    private Map<Integer, List<Vertex>> vsets = new HashMap<Integer, List<Vertex>>();
    private Map<Integer, List<float[]>> nsets = new HashMap<Integer, List<float[]>>();
    private Map<Integer, List<float[]>> tsets = new HashMap<Integer, List<float[]>>();
    private Map<Integer, List<float[]>> bnsets = new HashMap<Integer, List<float[]>>();
    private Map<Integer, List<float[]>> tansets = new HashMap<Integer, List<float[]>>();
    private Map<Vertex, List<Tuple2<Integer, Float>>> influences = new HashMap<Vertex, List<Tuple2<Integer, Float>>>();

    public static PolygonData create(int vertexCount) {
        PolygonData instance = new PolygonData(vertexCount);
        return instance;
    }

    private PolygonData(int vertexCount) {
        this.vertexCount = vertexCount;
    }

    public Set<Integer> getVertexSets() {
        return new TreeSet<Integer>(this.vsets.keySet());
    }

    public Set<Integer> getNormalSets() {
        return new TreeSet<Integer>(this.nsets.keySet());
    }

    public Set<Integer> getTexcoordSets() {
        return new TreeSet<Integer>(this.tsets.keySet());
    }

    public Set<Integer> getBinormalSets() {
        return new TreeSet<Integer>(this.bnsets.keySet());
    }

    public Set<Integer> getTangentSets() {
        return new TreeSet<Integer>(this.tansets.keySet());
    }

    public PolygonData[] triangulate() {
        if (this.vertexCount <= 3) {
            return new PolygonData[]{this};
        }
        int tricount = this.vertexCount - 2;
        PolygonData[] tris = new PolygonData[tricount];
        boolean tri = false;
        int vindex = 1;
        int i = 0;
        while (i < tricount) {
            PolygonData p = PolygonData.create(3);
            for (Map.Entry<Integer, List<Vertex>> entry : this.vsets.entrySet()) {
                Vertex v0 = entry.getValue().get(0);
                Vertex v1 = entry.getValue().get(vindex);
                Vertex v2 = entry.getValue().get(vindex + 1);
                p.pushVertex(entry.getKey(), v0.getIndex(), v0.getData());
                p.pushVertex(entry.getKey(), v1.getIndex(), v1.getData());
                p.pushVertex(entry.getKey(), v2.getIndex(), v2.getData());
            }
            for (Map.Entry<Integer, List<Vertex>> entry : this.nsets.entrySet()) {
                p.pushNormal(entry.getKey(), (float[])entry.getValue().get(0));
                p.pushNormal(entry.getKey(), (float[])entry.getValue().get(vindex));
                p.pushNormal(entry.getKey(), (float[])entry.getValue().get(vindex + 1));
            }
            for (Map.Entry<Integer, List<Vertex>> entry : this.tsets.entrySet()) {
                p.pushTexcoord(entry.getKey(), (float[])entry.getValue().get(0));
                p.pushTexcoord(entry.getKey(), (float[])entry.getValue().get(vindex));
                p.pushTexcoord(entry.getKey(), (float[])entry.getValue().get(vindex + 1));
            }
            for (Map.Entry<Integer, List<Vertex>> entry : this.bnsets.entrySet()) {
                p.pushBinormal(entry.getKey(), (float[])entry.getValue().get(0));
                p.pushBinormal(entry.getKey(), (float[])entry.getValue().get(vindex));
                p.pushBinormal(entry.getKey(), (float[])entry.getValue().get(vindex + 1));
            }
            for (Map.Entry<Integer, List<Vertex>> entry : this.tansets.entrySet()) {
                p.pushTangent(entry.getKey(), (float[])entry.getValue().get(0));
                p.pushTangent(entry.getKey(), (float[])entry.getValue().get(vindex));
                p.pushTangent(entry.getKey(), (float[])entry.getValue().get(vindex + 1));
            }
            tris[i] = p;
            ++i;
            ++vindex;
        }
        return tris;
    }

    public int getVertexCount() {
        return this.vertexCount;
    }

    public void pushTangent(int set, float[] tandata) throws IllegalStateException {
        List<float[]> list = this.getTangentSet(set);
        this.checkSize(list);
        list.add(tandata);
    }

    public void pushTexcoord(int set, float[] tdata) throws IllegalStateException {
        List<float[]> tset = this.getTexcoordSet(set);
        this.checkSize(tset);
        tset.add(tdata);
    }

    public void pushNormal(int set, float[] vdata) throws IllegalStateException {
        List<float[]> nset = this.getNormalSet(set);
        this.checkSize(nset);
        nset.add(vdata);
    }

    public void pushBinormal(int set, float[] bndata) throws IllegalStateException {
        List<float[]> list = this.getBinormalSet(set);
        this.checkSize(list);
        list.add(bndata);
    }

    public void pushVertex(int set, int originalIndex, float[] vdata) throws IllegalStateException {
        List<Vertex> vset = this.getVertexSet(set);
        this.checkSize(vset);
        Vertex v = Vertex.create(originalIndex, vdata);
        vset.add(v);
    }

    public void popTexcoordSet(int set, FloatBuffer buffer) {
        for (float[] fs : this.tsets.get(set)) {
            buffer.put(fs);
        }
    }

    public void popNormalSet(int set, FloatBuffer buffer) {
        for (float[] fs : this.nsets.get(set)) {
            buffer.put(fs);
        }
    }

    public void popBinormalSet(int set, FloatBuffer buffer) {
        for (float[] fs : this.bnsets.get(set)) {
            buffer.put(fs);
        }
    }

    public void popVertexSet(int set, FloatBuffer buffer) {
        for (Vertex vertex : this.vsets.get(set)) {
            buffer.put(vertex.getData());
        }
    }

    public void popTangentSet(int set, FloatBuffer buffer) {
        for (float[] fs : this.tansets.get(set)) {
            buffer.put(fs);
        }
    }

    public int getTexcoordStride(int set) {
        return this.tsets.get(set).get(0).length;
    }

    public int getNormalStride(int set) {
        return this.nsets.get(set).get(0).length;
    }

    public int getBinormalStride(int set) {
        return this.bnsets.get(set).get(0).length;
    }

    public int getVertexStride(int set) {
        return 3;
    }

    public int getTangentStride(int set) {
        return this.tansets.get(set).get(0).length;
    }

    private void checkSize(List<?> list) {
        if (list.size() == this.vertexCount) {
            throw new IllegalStateException("Polygon is full");
        }
    }

    private List<float[]> getTangentSet(int set) {
        List<float[]> list = this.tansets.get(set);
        if (list == null) {
            this.tansets.put(set, new ArrayList(this.vertexCount));
        }
        return list;
    }

    private List<float[]> getBinormalSet(int set) {
        List<float[]> list = this.bnsets.get(set);
        if (list == null) {
            list = new ArrayList<float[]>(this.vertexCount);
            this.bnsets.put(set, list);
        }
        return list;
    }

    private List<float[]> getTexcoordSet(int set) {
        List<float[]> list = this.tsets.get(set);
        if (list == null) {
            list = new ArrayList<float[]>(this.vertexCount);
            this.tsets.put(set, list);
        }
        return list;
    }

    private List<float[]> getNormalSet(int set) {
        List<float[]> list = this.nsets.get(set);
        if (list == null) {
            list = new ArrayList<float[]>(this.vertexCount);
            this.nsets.put(set, list);
        }
        return list;
    }

    private List<Vertex> getVertexSet(int set) {
        List<Vertex> list = this.vsets.get(set);
        if (list == null) {
            list = new ArrayList<Vertex>(this.vertexCount);
            this.vsets.put(set, list);
        }
        return list;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Polygon(").append(this.vertexCount).append(")");
        for (Map.Entry<Integer, List<Vertex>> entry : this.vsets.entrySet()) {
            buffer.append("VSET(").append(entry.getKey()).append(")");
            for (Vertex vertex : entry.getValue()) {
                buffer.append(vertex);
            }
        }
        return buffer.toString();
    }

    public void pushVertexSkinningData(List<VertexSkinningData> vsdList) {
        List<Vertex> defaultVertexSet = this.vsets.get(0);
        for (Vertex vertex : defaultVertexSet) {
            List<Tuple2<Integer, Float>> inf = this.getInfluenceData(vertex);
            VertexSkinningData skin = this.getSkinData(vertex, vsdList);
            if (skin == null) continue;
            Tuple2<Integer, Float> t = Tuple2.create(skin.getBoneIndex(), Float.valueOf(skin.getWeight()));
            inf.add(t);
        }
    }

    public void popVertexSkinningData(ByteBuffer boneIndicesData, FloatBuffer boneWeightData) {
        for (Vertex v : this.vsets.get(0)) {
            List<Tuple2<Integer, Float>> data = this.getInfluenceData(v);
            byte[] bones = new byte[4];
            float[] weights = new float[4];
            this.popInfluenceData(data, bones, weights);
            boneIndicesData.put(bones);
            boneWeightData.put(weights);
        }
    }

    private VertexSkinningData getSkinData(Vertex vertex, List<VertexSkinningData> vsdList) {
        for (VertexSkinningData vertexSkinningData : vsdList) {
            if (vertexSkinningData.getVertexIndex() != vertex.getIndex()) continue;
            return vertexSkinningData;
        }
        return null;
    }

    private List<Tuple2<Integer, Float>> getInfluenceData(Vertex vertex) {
        List<Tuple2<Integer, Float>> list = this.influences.get(vertex);
        if (list == null) {
            list = new ArrayList<Tuple2<Integer, Float>>(4);
            this.influences.put(vertex, list);
        }
        return list;
    }

    private void popInfluenceData(List<Tuple2<Integer, Float>> data, byte[] bones, float[] weights) {
        if (bones.length != 4 || weights.length != 4) {
            throw new IllegalArgumentException("buffers size must be 4");
        }
        for (int i = 0; i < 4; ++i) {
            if (i >= data.size()) continue;
            Tuple2<Integer, Float> inf = data.get(i);
            bones[i] = inf.getA().byteValue();
            weights[i] = inf.getB().floatValue();
        }
        this.normalize(weights);
    }

    private void normalize(float[] weights) {
        int i;
        float n = 0.0f;
        for (i = 0; i < weights.length; ++i) {
            n += weights[i] * weights[i];
        }
        if (n != 0.0f) {
            n = (float)Math.sqrt(n);
            i = 0;
            while (i < weights.length) {
                int n2 = i++;
                weights[n2] = weights[n2] / n;
            }
        }
    }
}

