/*
 * Decompiled with CFR 0.152.
 */
package jme3dae.collada14.transformers;

import jme3dae.collada14.ColladaSpec141;
import jme3dae.collada14.transformers.PolygonData;
import jme3dae.utilities.IndexExtractor;
import jme3dae.utilities.Todo;

public class InputShared {
    private final int stride;
    private final String[] idrefBuffer;
    private final String[] nameBuffer;
    private final boolean[] boolBuffer;
    private final float[] floatBuffer;
    private final int[] intBuffer;
    private final ColladaSpec141.Semantic semantic;
    private final int offset;
    private final int set;

    public static InputShared create(ColladaSpec141.Semantic semantic, Integer offset, Integer stride, Integer set, String[] idref, String[] name, boolean[] bool, float[] floats, int[] ints) {
        InputShared instance = new InputShared(semantic, offset == null ? 0 : offset, stride == null ? 1 : stride, set == null ? 0 : set, idref, name, bool, floats, ints);
        return instance;
    }

    private InputShared(ColladaSpec141.Semantic s, int offset, int stride, int set, String[] idref, String[] name, boolean[] bool, float[] floats, int[] ints) {
        this.set = set;
        this.offset = offset;
        this.semantic = s;
        this.stride = stride;
        this.idrefBuffer = idref;
        this.nameBuffer = name;
        this.boolBuffer = bool;
        this.floatBuffer = floats;
        this.intBuffer = ints;
    }

    public int getOffset() {
        return this.offset;
    }

    public void transferData(int chunkSize, int[] chunks, PolygonData[] polygons) {
        int[] indices = IndexExtractor.create(chunkSize, chunks).get(this.offset);
        switch (this.semantic) {
            case VERTEX: 
            case POSITION: {
                if (this.floatBuffer == null) break;
                this.transferVertices(indices, polygons, this.floatBuffer);
                break;
            }
            case NORMAL: {
                if (this.floatBuffer == null) break;
                this.transferNormals(indices, polygons, this.floatBuffer);
                break;
            }
            case BINORMAL: {
                if (this.floatBuffer == null) break;
                this.transferBinormals(indices, polygons, this.floatBuffer);
                break;
            }
            case TEXCOORD: {
                if (this.floatBuffer == null) break;
                this.transferTexCoords(indices, polygons, this.floatBuffer);
                break;
            }
            case TANGENT: {
                if (this.floatBuffer == null) break;
                this.transferTangents(indices, polygons, this.floatBuffer);
                break;
            }
            default: {
                Todo.task("implement transfer of input type " + (Object)((Object)this.semantic));
            }
        }
    }

    private void transferVertices(int[] indices, PolygonData[] polygons, float[] floatBuffer) {
        int index = 0;
        for (int polygon = 0; index < indices.length && polygon < polygons.length; ++polygon) {
            int i = 0;
            while (i < polygons[polygon].getVertexCount() & index < indices.length) {
                float[] vdata = this.getFloatSet(floatBuffer, this.stride, indices[index]);
                polygons[polygon].pushVertex(this.set, indices[index], vdata);
                ++index;
                ++i;
            }
        }
    }

    private void transferNormals(int[] indices, PolygonData[] polygons, float[] floatBuffer) {
        int index = 0;
        for (int polygon = 0; index < indices.length && polygon < polygons.length; ++polygon) {
            int i = 0;
            while (i < polygons[polygon].getVertexCount() & index < indices.length) {
                float[] vdata = this.getFloatSet(floatBuffer, this.stride, indices[index]);
                polygons[polygon].pushNormal(this.set, vdata);
                ++index;
                ++i;
            }
        }
    }

    private void transferBinormals(int[] indices, PolygonData[] polygons, float[] floatBuffer) {
        int index = 0;
        for (int polygon = 0; index < indices.length && polygon < polygons.length; ++polygon) {
            int i = 0;
            while (i < polygons[polygon].getVertexCount() & index < indices.length) {
                float[] vdata = this.getFloatSet(floatBuffer, this.stride, indices[index]);
                polygons[polygon].pushBinormal(this.set, vdata);
                ++index;
                ++i;
            }
        }
    }

    private void transferTexCoords(int[] indices, PolygonData[] polygons, float[] floatBuffer) {
        int index = 0;
        for (int polygon = 0; index < indices.length && polygon < polygons.length; ++polygon) {
            int i = 0;
            while (i < polygons[polygon].getVertexCount() & index < indices.length) {
                float[] vdata = this.getFloatSet(floatBuffer, this.stride, indices[index]);
                polygons[polygon].pushTexcoord(this.set, vdata);
                ++index;
                ++i;
            }
        }
    }

    private void transferTangents(int[] indices, PolygonData[] polygons, float[] floatBuffer) {
        int index = 0;
        for (int polygon = 0; index < indices.length && polygon < polygons.length; ++polygon) {
            int i = 0;
            while (i < polygons[polygon].getVertexCount() & index < indices.length) {
                float[] vdata = this.getFloatSet(floatBuffer, this.stride, indices[index]);
                polygons[polygon].pushTangent(this.set, vdata);
                ++index;
                ++i;
            }
        }
    }

    private float[] getFloatSet(float[] floatBuffer, int stride, int i) {
        float[] buffer = new float[stride];
        System.arraycopy(floatBuffer, i * stride, buffer, 0, stride);
        return buffer;
    }
}

