/*
 * Decompiled with CFR 0.152.
 */
package jme3dae.collada14.transformers;

import com.jme3.material.Material;
import com.jme3.scene.Geometry;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import jme3dae.DAENode;
import jme3dae.collada14.transformers.InputShared;
import jme3dae.collada14.transformers.InputSharedTransformer;
import jme3dae.transformers.ValueTransformer;
import jme3dae.utilities.Bindings;
import jme3dae.utilities.Todo;
import jme3dae.utilities.TransformerPack;
import jme3dae.utilities.Tuple2;

public abstract class GeometryTransformer<A, B>
implements TransformerPack<A, B> {
    private static final InputSharedTransformer INPUT_SHARED = InputSharedTransformer.create();

    protected Tuple2<Integer, List<InputShared>> getInputs(DAENode inputParent) {
        LinkedList<InputShared> inputs = new LinkedList<InputShared>();
        int chunkSize = 0;
        for (DAENode input : inputParent.getChildren("input")) {
            ValueTransformer.TransformedValue<InputShared> buffer = INPUT_SHARED.transform(input);
            if (!buffer.isDefined()) continue;
            inputs.add(buffer.get());
            chunkSize = Math.max(chunkSize, buffer.get().getOffset());
        }
        return Tuple2.create(++chunkSize, inputs);
    }

    protected void applyMaterial(Geometry geom, DAENode geomDataNode, Bindings bindings) {
        ValueTransformer.TransformedValue<String> linkedSymbol = geomDataNode.getAttribute("material", TEXT);
        if (linkedSymbol.isDefined()) {
            DAENode material;
            ValueTransformer.TransformedValue<String> transformedValue;
            DAENode bindMaterial = bindings.get("bind_material", DAENode.class);
            List<DAENode> instanceMaterials = bindMaterial.getChild("technique_common").getChildren("instance_material");
            HashMap<String, DAENode> instanceMaterialsForSymbol = new HashMap<String, DAENode>();
            for (DAENode dAENode : instanceMaterials) {
                ValueTransformer.TransformedValue<String> symbol = dAENode.getAttribute("symbol", TEXT);
                if (!symbol.isDefined()) continue;
                instanceMaterialsForSymbol.put(symbol.get(), dAENode);
            }
            DAENode instanceMaterial = (DAENode)instanceMaterialsForSymbol.get(linkedSymbol.get());
            if (instanceMaterial == null) {
                instanceMaterial = DAENode.NONE;
                Todo.task("Material symbol not found, trying to guess it...");
                for (String string : instanceMaterialsForSymbol.keySet()) {
                    if (!string.toLowerCase().startsWith(linkedSymbol.get())) continue;
                    instanceMaterial = (DAENode)instanceMaterialsForSymbol.get(string);
                    Todo.task("Guessed " + string);
                    break;
                }
            }
            if ((transformedValue = instanceMaterial.getAttribute("target", TEXT)).isDefined() && (material = bindMaterial.getLinkedNode(transformedValue.get())).isDefined()) {
                Material parsedData = material.getParsedData(Material.class);
                Material clone = parsedData.clone();
                geom.setMaterial(clone);
            }
        }
    }

    protected int[] merge(int[] head, int[] tail) {
        int[] buffer = new int[head.length + tail.length];
        System.arraycopy(head, 0, buffer, 0, head.length);
        System.arraycopy(tail, 0, buffer, head.length, tail.length);
        return buffer;
    }
}

