/*
 * Decompiled with CFR 0.152.
 */
package jme3dae.collada14;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3dae.DAENode;
import jme3dae.FXEnhancerInfo;
import jme3dae.collada14.transformers.LibraryImagesTransformer;
import jme3dae.collada14.transformers.LibraryMaterialsTransformer;
import jme3dae.collada14.transformers.SceneTransformer;
import jme3dae.transformers.ValueTransformer;
import jme3dae.utilities.Conditions;
import jme3dae.utilities.FloatTransformer;
import jme3dae.utilities.MeasuringUnit;
import jme3dae.utilities.PlainTextTransformer;
import jme3dae.utilities.Tuple2;
import jme3dae.utilities.UpAxis;

public class ColladaDocumentV14
implements ValueTransformer<Tuple2<DAENode, AssetManager>, Node> {
    private final FXEnhancerInfo fxInfo;

    public static ColladaDocumentV14 create(FXEnhancerInfo fx) {
        return new ColladaDocumentV14(fx);
    }

    private ColladaDocumentV14(FXEnhancerInfo fx) {
        this.fxInfo = fx;
    }

    @Override
    public ValueTransformer.TransformedValue<Node> transform(Tuple2<DAENode, AssetManager> value) {
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "ColladaParser v. 0.1");
        DAENode colladaNode = value.getA();
        Conditions.checkTrue(value.getA().hasName("COLLADA"), "Expected COLLADA, got " + value.getA());
        this.parseColladaNode(colladaNode);
        LibraryImagesTransformer libraryImagesTransformer = LibraryImagesTransformer.create();
        for (DAENode dAENode : value.getA().getChildren("library_images")) {
            libraryImagesTransformer.transform(Tuple2.create(dAENode, value.getB()));
        }
        LibraryMaterialsTransformer libraryMaterialsTransformer = LibraryMaterialsTransformer.create();
        for (DAENode libraryMaterial : value.getA().getChildren("library_materials")) {
            libraryMaterialsTransformer.transform(Tuple2.create(libraryMaterial, value.getB()));
        }
        Node node = new Node("COLLADA SCENE");
        DAENode scene = value.getA().getChild("scene");
        if (scene.isDefined()) {
            SceneTransformer.create().transform(Tuple2.create(scene, node));
        }
        if (value.getB() != null) {
            this.applyDefaultMaterial(value.getB(), node);
        } else {
            System.err.println("AssetManager is null, testing aren't we?");
        }
        return ValueTransformer.TransformedValue.create(node);
    }

    private void applyDefaultMaterial(AssetManager am, Node root) {
        Material red = am.loadMaterial("Common/Materials/RedColor.j3m");
        LinkedList<Node> stack = new LinkedList<Node>();
        stack.push(root);
        while (!stack.isEmpty()) {
            Node n;
            Spatial s = (Spatial)stack.pop();
            if (s instanceof Geometry) {
                Geometry g = (Geometry)s;
                if (g.getMaterial() != null) continue;
                g.setMaterial(red);
                continue;
            }
            if (!(s instanceof Node) || (n = (Node)s).getQuantity() <= 0) continue;
            stack.addAll(n.getChildren());
        }
    }

    private void parseColladaNode(DAENode colladaNode) {
        MeasuringUnit unit = MeasuringUnit.create(1.0f);
        UpAxis upAxis = UpAxis.Y_UP;
        DAENode asset = colladaNode.getChild("asset");
        if (asset.isDefined()) {
            DAENode ua;
            DAENode u = asset.getChild("unit");
            if (u.isDefined()) {
                unit = MeasuringUnit.create(u.getAttribute("meter", FloatTransformer.create()).get().floatValue());
            }
            if ((ua = asset.getChild("up_axis")).isDefined()) {
                ValueTransformer.TransformedValue<String> content = ua.getContent(PlainTextTransformer.create());
                if (content.contains("Z_UP")) {
                    upAxis = UpAxis.Z_UP;
                } else if (content.contains("Y_UP")) {
                    upAxis = UpAxis.Y_UP;
                } else if (content.contains("X_UP")) {
                    upAxis = UpAxis.X_UP;
                }
            }
        }
        if (this.fxInfo.getIgnoreMeasuringUnit()) {
            unit = MeasuringUnit.create(1.0f);
        }
        colladaNode.setParsedData((Object)upAxis);
        colladaNode.setParsedData(unit);
        colladaNode.setParsedData(this.fxInfo);
    }
}

