/*
 * Decompiled with CFR 0.152.
 */
package jme3dae;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.animation.Animation;
import com.jme3.animation.Bone;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.LoopMode;
import com.jme3.animation.Skeleton;
import com.jme3.animation.Track;
import com.jme3.app.SimpleApplication;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.control.Control;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.HashMap;

public class ScratchAnimationTest
extends SimpleApplication {
    private Mesh debmesh;
    private int loop;

    public static void main(String[] args) {
        new ScratchAnimationTest().start();
    }

    public static void printFloatBuffer(String label, VertexBuffer buffer) {
        FloatBuffer data = (FloatBuffer)buffer.getData();
        data.rewind();
        System.out.print(label);
        while (data.hasRemaining()) {
            System.out.print(data.get() + " ");
        }
        System.out.println("");
        data.rewind();
    }

    public void simpleInitApp() {
        this.renderer.setBackgroundColor(ColorRGBA.Gray);
        float[] normals = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
        float[] positions = new float[]{-1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f};
        int[] indices = new int[]{0, 1, 2};
        float[] weights = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f};
        byte[] bones = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        Mesh mesh = new Mesh();
        mesh.setBuffer(VertexBuffer.Type.Position, 3, (float[])positions.clone());
        mesh.setBuffer(VertexBuffer.Type.Normal, 3, (float[])normals.clone());
        mesh.setBuffer(VertexBuffer.Type.Index, 1, (int[])indices.clone());
        mesh.setBuffer(VertexBuffer.Type.BindPosePosition, 3, (float[])positions.clone());
        mesh.setBuffer(VertexBuffer.Type.BindPoseNormal, 3, (float[])normals.clone());
        VertexBuffer vertexWeightBuffer = new VertexBuffer(VertexBuffer.Type.BoneWeight);
        VertexBuffer boneIndexBuffer = new VertexBuffer(VertexBuffer.Type.BoneIndex);
        vertexWeightBuffer.setupData(VertexBuffer.Usage.CpuOnly, 4, VertexBuffer.Format.Float, (Buffer)FloatBuffer.wrap(weights));
        boneIndexBuffer.setupData(VertexBuffer.Usage.CpuOnly, 4, VertexBuffer.Format.UnsignedByte, (Buffer)ByteBuffer.wrap(bones));
        mesh.setBuffer(vertexWeightBuffer);
        mesh.setBuffer(boneIndexBuffer);
        Geometry geom = new Geometry("triangle", mesh);
        geom.setMaterial(this.assetManager.loadMaterial("/Common/Materials/RedColor.j3m"));
        Node node = new Node("geom owner");
        node.attachChild((Spatial)geom);
        Bone bone = new Bone("bone 0");
        bone.setBindTransforms(new Vector3f(0.0f, 0.0f, 0.0f), new Quaternion(Quaternion.IDENTITY), new Vector3f(Vector3f.UNIT_XYZ));
        Skeleton skeleton = new Skeleton(new Bone[]{bone});
        skeleton.setBindingPose();
        skeleton.updateWorldVectors();
        skeleton.resetAndUpdate();
        skeleton.computeSkinningMatrices();
        float[] times = new float[]{0.0f, 10.0f};
        Vector3f[] translations = new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 2.0f, 0.0f)};
        Quaternion[] rotations = new Quaternion[]{new Quaternion(0.0f, 0.0f, 0.0f, 1.0f), new Quaternion(0.0f, 0.0f, 0.0f, 1.0f)};
        BoneTrack boneTrack = new BoneTrack(0, times, translations, rotations);
        Animation boneAnim = new Animation("test animation", 3.0f);
        boneAnim.setTracks((Track[])new BoneTrack[]{boneTrack});
        AnimControl anim = new AnimControl(skeleton);
        anim.setAnimations(new HashMap());
        anim.addAnim(boneAnim);
        AnimChannel channel = anim.createChannel();
        channel.setAnim("test animation");
        channel.setLoopMode(LoopMode.Loop);
        channel.setSpeed(0.5f);
        node.addControl((Control)anim);
        this.rootNode.attachChild((Spatial)node);
        this.debmesh = geom.getMesh();
    }

    public void simpleUpdate(float tpf) {
        super.simpleUpdate(tpf);
        if (this.loop++ % 1000 == 0) {
            ScratchAnimationTest.printFloatBuffer("Position:     ", this.debmesh.getBuffer(VertexBuffer.Type.Position));
            ScratchAnimationTest.printFloatBuffer("BindPosition: ", this.debmesh.getBuffer(VertexBuffer.Type.BindPosePosition));
        }
    }
}

