/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ros2.example;

import org.apache.commons.lang3.SystemUtils;
import std_msgs.msg.dds.Int64;
import std_msgs.msg.dds.Int64PubSubType;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.ros2.QueuedROS2Subscription;
import us.ihmc.ros2.ROS2PublisherBasics;
import us.ihmc.ros2.ROS2QosProfile;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.util.PeriodicNonRealtimeThreadSchedulerFactory;
import us.ihmc.util.PeriodicRealtimeThreadSchedulerFactory;
import us.ihmc.util.PeriodicThreadSchedulerFactory;

public class RealtimeROS2PublishSubscribeExample {
    private ROS2PublisherBasics<Int64> publisher;
    private QueuedROS2Subscription<Int64> subscription;

    public RealtimeROS2PublishSubscribeExample() {
        RealtimeROS2Node node;
        try {
            node = this.setupNode(SystemUtils.IS_OS_LINUX);
            node.spin();
        }
        catch (RuntimeException e) {
            LogTools.error((String)e.getMessage());
            LogTools.warn((String)"Using non-realtime.");
            node = this.setupNode(false);
            node.spin();
        }
        Int64 message = new Int64();
        for (int i = 0; i < 10; ++i) {
            message.setData((long)i);
            this.publisher.publish((Object)message);
            System.out.println("Sending: " + message);
        }
        Int64 incomingMessage = new Int64();
        while (!this.subscription.poll((Object)incomingMessage)) {
        }
        System.out.println("Receiving: " + incomingMessage);
        int i = 1;
        while (i < 10) {
            if (!this.subscription.poll((Object)incomingMessage)) continue;
            System.out.println("Receiving: " + incomingMessage);
            ++i;
        }
        System.out.println("Received all messages!");
        node.destroy();
    }

    private RealtimeROS2Node setupNode(boolean useRealtimeThread) {
        PeriodicRealtimeThreadSchedulerFactory threadFactory = useRealtimeThread ? new PeriodicRealtimeThreadSchedulerFactory(20) : new PeriodicNonRealtimeThreadSchedulerFactory();
        RealtimeROS2Node node = new RealtimeROS2Node(DomainFactory.getDomain((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS), (PeriodicThreadSchedulerFactory)threadFactory, "RealtimeROS2PublishSubscribeExample");
        this.publisher = node.createPublisher((TopicDataType)new Int64PubSubType(), "/example", ROS2QosProfile.KEEP_HISTORY((int)3), 10);
        this.subscription = node.createQueuedSubscription((TopicDataType)new Int64PubSubType(), "/example", ROS2QosProfile.KEEP_HISTORY((int)3), 10);
        return node;
    }

    public static void main(String[] args) {
        new RealtimeROS2PublishSubscribeExample();
    }
}

