/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ros2;

import com.google.common.base.CaseFormat;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import std_msgs.msg.dds.Bool;
import std_msgs.msg.dds.Float32;
import std_msgs.msg.dds.Float64;
import std_msgs.msg.dds.Int32;
import std_msgs.msg.dds.Int8;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.ros2.ROS2QosProfile;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.ROS2TopicNameTools;

public class ROS2TopicTest {
    @Test
    public void testEqualsAndHash() {
        ROS2Topic topicName1 = new ROS2Topic().withPrefix("ihmc");
        ROS2Topic topicName2 = new ROS2Topic().withPrefix("ihmc");
        Assertions.assertEquals((Object)topicName1, (Object)topicName2);
        HashMap map = new HashMap();
        map.put(topicName1, null);
        map.put(topicName2, null);
        Assertions.assertEquals((int)1, (int)map.size());
        ROS2Topic topicName3 = new ROS2Topic().withPrefix("ihmc").withTypeName(Int32.class);
        ROS2Topic topicName4 = new ROS2Topic().withPrefix("ihmc").withTypeName(Int32.class);
        Assertions.assertEquals((Object)topicName1, (Object)topicName2);
        HashMap map2 = new HashMap();
        map2.put(topicName3, null);
        map2.put(topicName4, null);
        Assertions.assertEquals((int)1, (int)map2.size());
    }

    @Test
    public void testROS2TopicName() {
        ROS2Topic topicName = new ROS2Topic().withPrefix("ihmc").withRobot("atlas").withModule("rea").withTypeName(ExampleTypeMessage.class).withTypeName().withSuffix("one");
        Assertions.assertEquals((Object)"/ihmc/atlas/rea/example_type/one", (Object)topicName.toString());
        ROS2Topic ihmcPrefixed = new ROS2Topic().withPrefix("ihmc");
        Assertions.assertEquals((Object)"/ihmc", (Object)ihmcPrefixed.toString());
        ihmcPrefixed.withModule("hello");
        ihmcPrefixed.withRobot("robot_one");
        ihmcPrefixed.withTypeName(Int8.class);
        ihmcPrefixed.withSuffix("meow");
        ihmcPrefixed.withInput();
        ihmcPrefixed.withOutput();
        ihmcPrefixed.withIOQualifier("client");
        ihmcPrefixed.withIOQualifier("server");
        ihmcPrefixed.withQoS(ROS2QosProfile.RELIABLE());
        Assertions.assertEquals((Object)"/ihmc", (Object)ihmcPrefixed.toString());
        Assertions.assertEquals((Object)"/ihmc/cat/bengal_tiger", (Object)ihmcPrefixed.withModule("cat/bengal_tiger").getName());
        ROS2Topic ihmcPrefixed2 = new ROS2Topic().withPrefix("ihmc");
        Assertions.assertEquals((Object)"/ihmc", (Object)ihmcPrefixed2.toString());
        ROS2Topic hello = ihmcPrefixed2.withModule("hello");
        ROS2Topic robotOne = hello.withRobot("robot_one");
        ROS2Topic int8 = robotOne.withTypeName(Int8.class);
        ROS2Topic meow = int8.withSuffix("meow");
        ROS2Topic input = meow.withInput();
        ROS2Topic output = input.withOutput();
        Assertions.assertEquals((Object)"/ihmc/hello", (Object)hello.toString());
        Assertions.assertEquals((Object)"/ihmc/robot_one/hello", (Object)robotOne.toString());
        Assertions.assertEquals((Object)"/ihmc/robot_one/hello/int8", (Object)int8.toString());
        Assertions.assertEquals((Object)"/ihmc/robot_one/hello/int8/meow", (Object)meow.toString());
        Assertions.assertEquals((Object)"/ihmc/robot_one/hello/input/int8/meow", (Object)input.toString());
        Assertions.assertEquals((Object)"/ihmc/robot_one/hello/output/int8/meow", (Object)output.toString());
        ROS2Topic meowReliable = output.withQoS(ROS2QosProfile.RELIABLE());
        Assertions.assertEquals((Object)"/ihmc/robot_one/hello/output/int8/meow", (Object)meowReliable.toString());
        Assertions.assertEquals((Object)ROS2QosProfile.RELIABLE(), (Object)meowReliable.getQoS());
        Assertions.assertNotEquals((Object)output, (Object)meowReliable);
        ROS2Topic meowBestEffort = meowReliable.withSuffix("meow_best_effort");
        Assertions.assertEquals((Object)ROS2QosProfile.RELIABLE(), (Object)meowBestEffort.getQoS());
        meowBestEffort = meowBestEffort.withQoS(ROS2QosProfile.BEST_EFFORT());
        Assertions.assertEquals((Object)ROS2QosProfile.BEST_EFFORT(), (Object)meowBestEffort.getQoS());
        Assertions.assertEquals((Object)"/ihmc/robot_one/hello/output/int8/meow_best_effort", (Object)meowBestEffort.toString());
        Assertions.assertEquals((Object)"/ihmc", (Object)output.withSuffix("").withIOQualifier(null).withModule(null).withRobot(null).clearTypeName().toString());
        Assertions.assertEquals((Object)"", (Object)output.withPrefix(null).withIOQualifier(null).withSuffix("").withModule(null).withRobot(null).clearTypeName().toString());
    }

    @Test
    public void testRedundantModificationReturnsThis() {
        ROS2Topic empty = new ROS2Topic();
        Assertions.assertSame((Object)empty, (Object)empty.withPrefix(""));
        Assertions.assertSame((Object)empty, (Object)empty.withRobot(""));
        Assertions.assertSame((Object)empty, (Object)empty.withModule(""));
        Assertions.assertSame((Object)empty, (Object)empty.withIOQualifier(""));
        Assertions.assertSame((Object)empty, (Object)empty.clearTypeName());
        Assertions.assertSame((Object)empty, (Object)empty.withSuffix(""));
        Assertions.assertNotSame((Object)empty, (Object)empty.withType(Bool.class));
        ROS2Topic root = empty.withPrefix("ihmc");
        Assertions.assertNull((Object)root.getType());
        Assertions.assertNotSame((Object)root, (Object)root.withPrefix(""));
        Assertions.assertSame((Object)root, (Object)root.withPrefix("ihmc"));
        Assertions.assertSame((Object)root, (Object)root.withRobot(""));
        Assertions.assertSame((Object)root, (Object)root.withModule(""));
        Assertions.assertSame((Object)root, (Object)root.withIOQualifier(""));
        Assertions.assertSame((Object)root, (Object)root.clearTypeName());
        Assertions.assertSame((Object)root, (Object)root.withSuffix(""));
        Assertions.assertNotSame((Object)root, (Object)root.withType(Float32.class));
        ROS2Topic float64Topic = root.withType(Float64.class);
        Assertions.assertNotSame((Object)float64Topic, (Object)float64Topic.withPrefix(""));
        Assertions.assertSame((Object)float64Topic, (Object)float64Topic.withRobot(""));
        Assertions.assertSame((Object)float64Topic, (Object)float64Topic.withModule(""));
        Assertions.assertSame((Object)float64Topic, (Object)float64Topic.withIOQualifier(""));
        Assertions.assertSame((Object)float64Topic, (Object)float64Topic.clearTypeName());
        Assertions.assertSame((Object)float64Topic, (Object)float64Topic.withSuffix(""));
        Assertions.assertSame((Object)float64Topic, (Object)float64Topic.withType(Float64.class));
    }

    @Test
    public void testExceptionsThrown() {
        ROS2Topic root = new ROS2Topic().withPrefix("ihmc");
        Assertions.assertThrows(RuntimeException.class, () -> root.withTypeName());
        Assertions.assertThrows(RuntimeException.class, () -> root.withType(null));
        ROS2Topic boolTopic = root.withType(Bool.class);
        Assertions.assertThrows(RuntimeException.class, () -> root.withTopic(boolTopic));
        Assertions.assertThrows(RuntimeException.class, () -> boolTopic.withTypeName(Int8.class));
        Assertions.assertThrows(RuntimeException.class, () -> boolTopic.withType(Int8.class));
        Assertions.assertDoesNotThrow(() -> boolTopic.withType(Bool.class));
        Assertions.assertDoesNotThrow(() -> boolTopic.withTypeName(Bool.class));
        Assertions.assertDoesNotThrow(() -> boolTopic.withTopic(boolTopic));
        ROS2Topic int8Topic = root.withType(Int8.class);
        ROS2Topic fooModule = new ROS2Topic().withModule("foo");
        ROS2Topic fooBoolTopic = boolTopic.withTopic(fooModule);
        Assertions.assertEquals((Object)"/ihmc/foo", (Object)fooBoolTopic.getName());
        Assertions.assertThrows(RuntimeException.class, () -> boolTopic.withTopic(int8Topic));
        Assertions.assertEquals(Int8.class, (Object)int8Topic.getType());
        Assertions.assertFalse((boolean)boolTopic.equals(null));
        Assertions.assertTrue((boolean)boolTopic.equals((Object)boolTopic));
    }

    @Test
    public void testTypeNaming() {
        ROS2Topic emptyTopic = new ROS2Topic();
        Assertions.assertEquals((Object)"", (Object)emptyTopic.getName());
        ROS2Topic withEmptyTypeNamed = new ROS2Topic().withType(Int8.class);
        Assertions.assertEquals((Object)"", (Object)withEmptyTypeNamed.getName());
        ROS2Topic typeNamed = new ROS2Topic().withTypeName(Int8.class).withTypeName();
        Assertions.assertEquals((Object)"/int8", (Object)typeNamed.getName());
        ROS2Topic usedTypeInName = new ROS2Topic().withType(Int8.class).withSuffix("int8_for_ui");
        Assertions.assertEquals((Object)"/int8_for_ui", (Object)usedTypeInName.getName());
        ROS2Topic withInput = typeNamed.withInput();
        Assertions.assertEquals((Object)"/input/int8", (Object)withInput.getName());
        ROS2Topic atlas = new ROS2Topic().withRobot("atlas").withPrefix("/ihmc");
        Assertions.assertEquals((Object)"/ihmc/atlas/input/int8", (Object)withInput.withTopic(atlas).getName());
    }

    @Test
    void testToROSTopicFormat() {
        ROS2TopicTest.compareAgainstGuava("", "");
        ROS2TopicTest.compareAgainstGuava("a", "a");
        ROS2TopicTest.compareAgainstGuava("a", "A");
        ROS2TopicTest.compareAgainstGuava("arm_trajectory", "ArmTrajectory");
        ROS2TopicTest.compareAgainstGuava("behavior_control_mode", "BehaviorControlMode");
        ROS2TopicTest.compareAgainstGuava("there_is_a_pine_tree", "ThereIsAPineTree");
        ROS2TopicTest.compareAgainstGuava("you_are_dah_best", "youAreDahBest");
        ROS2TopicTest.compareAgainstGuava("v2_forge", "V2Forge");
        ROS2TopicTest.compareAgainstGuava("v578_forge", "V578Forge");
        ROS2TopicTest.compareAgainstGuava("forge_v578", "ForgeV578");
        ROS2TopicTest.compareAgainstGuava("forge578", "Forge578");
        ROS2TopicTest.compareAgainstGuava("578_forge", "578Forge");
        String troublingString = "REAIsAnAcronymAndIsNotHandledByGuava";
        String guavaExpectedAnswer = "r_e_a_is_an_acronym_and_is_not_handled_by_guava";
        String rosTopicExpectedName = "rea_is_an_acronym_and_is_not_handled_by_guava";
        Assertions.assertEquals((Object)guavaExpectedAnswer, (Object)CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, troublingString));
        Assertions.assertEquals((Object)rosTopicExpectedName, (Object)ROS2TopicNameTools.toROSTopicFormat((String)troublingString));
        troublingString = "TheAcronymIsAtTheEndREA";
        guavaExpectedAnswer = "the_acronym_is_at_the_end_r_e_a";
        rosTopicExpectedName = "the_acronym_is_at_the_end_rea";
        Assertions.assertEquals((Object)guavaExpectedAnswer, (Object)CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, troublingString));
        Assertions.assertEquals((Object)rosTopicExpectedName, (Object)ROS2TopicNameTools.toROSTopicFormat((String)troublingString));
    }

    private static void compareAgainstGuava(String expectedOutput, String stringToEvaluate) {
        String guavaOutput = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, stringToEvaluate);
        String ros2ToolsOutput = ROS2TopicNameTools.toROSTopicFormat((String)stringToEvaluate);
        Assertions.assertEquals((Object)guavaOutput, (Object)ros2ToolsOutput);
        Assertions.assertEquals((Object)expectedOutput, (Object)ros2ToolsOutput);
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(ROS2Topic.class, ROS2TopicTest.class);
    }

    static class ExampleTypeMessage {
        ExampleTypeMessage() {
        }
    }
}

