/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.trajectories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class LinearInterpolater {
    private final double[] xPoints;
    private final double[] yPoints;
    private final int sizeOfVector;
    private int upperBoundIndex;
    private int lowerBoundIndex;

    public LinearInterpolater(double[] xPoints, double[] yPoints) {
        this.xPoints = xPoints;
        this.yPoints = yPoints;
        if (xPoints.length < 2) {
            throw new RuntimeException("LinearInterpolater: xPoints must have at least 2 points, length=" + xPoints.length);
        }
        if (!this.areXPointsInIncreasingOrder(xPoints)) {
            System.err.println(Arrays.toString(xPoints));
            throw new RuntimeException("LinearInterpolater: xPoints must be in increasing order");
        }
        if (xPoints.length != yPoints.length) {
            throw new RuntimeException("LinearInterpolater: xPoints and yPoints must be equal length");
        }
        this.sizeOfVector = xPoints.length;
    }

    public LinearInterpolater(ArrayList<Double> xPointsArrayList, ArrayList<Double> yPointsArrayList) throws Exception {
        if (xPointsArrayList.size() != yPointsArrayList.size()) {
            throw new RuntimeException("array lists must be equal size");
        }
        if (xPointsArrayList.size() < 2) {
            throw new Exception("LinearInterpolater: xPoints must have at least 2 points, length=" + xPointsArrayList.size());
        }
        if (xPointsArrayList.get(1) - xPointsArrayList.get(0) < 0.0) {
            Collections.reverse(xPointsArrayList);
            Collections.reverse(yPointsArrayList);
        }
        this.xPoints = new double[xPointsArrayList.size()];
        this.yPoints = new double[xPointsArrayList.size()];
        for (int i = 0; i < xPointsArrayList.size(); ++i) {
            this.xPoints[i] = xPointsArrayList.get(i);
            this.yPoints[i] = yPointsArrayList.get(i);
        }
        if (!this.areXPointsInIncreasingOrder(this.xPoints)) {
            System.err.println(Arrays.toString(this.xPoints));
            throw new Exception("LinearInterpolater: xPoints must be in increasing order");
        }
        this.sizeOfVector = this.xPoints.length;
    }

    public LinearInterpolater(ArrayList<Double> xPointsArrayList) throws Exception {
        if (xPointsArrayList.size() < 2) {
            throw new Exception("LinearInterpolater: xPoints must have at least 2 points, length=" + xPointsArrayList.size());
        }
        this.xPoints = new double[xPointsArrayList.size()];
        this.yPoints = new double[xPointsArrayList.size()];
        for (int i = 0; i < xPointsArrayList.size(); ++i) {
            this.xPoints[i] = xPointsArrayList.get(i);
            this.yPoints[i] = i;
        }
        if (!this.areXPointsInIncreasingOrder(this.xPoints)) {
            System.err.println(Arrays.toString(this.xPoints));
            throw new Exception("LinearInterpolater: xPoints must be in increasing order");
        }
        this.sizeOfVector = this.xPoints.length;
    }

    public double getPoint(double xPointValue) {
        this.lowerBoundIndex = 0;
        this.upperBoundIndex = this.sizeOfVector - 1;
        boolean foundPoint = false;
        while (!foundPoint) {
            foundPoint = this.updateBounds(xPointValue);
        }
        if (this.upperBoundIndex == this.lowerBoundIndex) {
            return this.yPoints[this.upperBoundIndex];
        }
        return this.interpolation(xPointValue);
    }

    public ArrayList<Double> getXpointsCopy() {
        ArrayList<Double> ret = new ArrayList<Double>();
        double[] dArray = this.xPoints;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double value = dArray[i];
            ret.add(value);
        }
        return ret;
    }

    public ArrayList<Double> getYpointsCopy() {
        ArrayList<Double> ret = new ArrayList<Double>();
        double[] dArray = this.yPoints;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double value = dArray[i];
            ret.add(value);
        }
        return ret;
    }

    private double interpolation(double xPointValue) {
        if (this.upperBoundIndex - this.lowerBoundIndex > 1) {
            throw new RuntimeException("LinearInterpolater: did not set the bounds properly");
        }
        double xMax = this.xPoints[this.upperBoundIndex];
        double xMin = this.xPoints[this.lowerBoundIndex];
        double yMax = this.yPoints[this.upperBoundIndex];
        double yMin = this.yPoints[this.lowerBoundIndex];
        if (xPointValue > xMax) {
            return yMax;
        }
        if (xPointValue < xMin) {
            return yMin;
        }
        double yDifference = yMax - yMin;
        double xDifference = xMax - xMin;
        double deltaX = xPointValue - xMin;
        double deltaY = deltaX * yDifference / xDifference;
        return yMin + deltaY;
    }

    private boolean updateBounds(double xPointValue) {
        if (this.upperBoundIndex - this.lowerBoundIndex <= 1) {
            return true;
        }
        int middlePointIndex = (int)((double)(this.upperBoundIndex + this.lowerBoundIndex) / 2.0);
        double xPointAtMiddle = this.xPoints[middlePointIndex];
        if (xPointValue > xPointAtMiddle) {
            this.lowerBoundIndex = middlePointIndex;
            if (this.upperBoundIndex - this.lowerBoundIndex <= 1) {
                return true;
            }
        } else if (xPointValue < xPointAtMiddle) {
            this.upperBoundIndex = middlePointIndex;
            if (this.upperBoundIndex - this.lowerBoundIndex <= 1) {
                return true;
            }
        } else {
            this.upperBoundIndex = middlePointIndex;
            this.lowerBoundIndex = middlePointIndex;
            return true;
        }
        return false;
    }

    private boolean areXPointsInIncreasingOrder(double[] points) {
        for (int i = 1; i < points.length; ++i) {
            if (!(points[i] <= points[i - 1])) continue;
            return false;
        }
        return true;
    }

    public double getMaxX() {
        return this.xPoints[this.xPoints.length - 1];
    }

    public double getMinX() {
        return this.xPoints[0];
    }

    public static void main(String[] args) {
        int numberOfPoints = 4;
        double[] xTestPoints = new double[numberOfPoints];
        double[] yTestPoints = new double[numberOfPoints];
        double xStart = 0.0;
        double deltaX = 1.0;
        xTestPoints[0] = 0.0;
        xTestPoints[1] = 0.5;
        xTestPoints[2] = 1.0;
        xTestPoints[3] = 2.0;
        yTestPoints[0] = 0.0;
        yTestPoints[1] = 1.0;
        yTestPoints[2] = 2.0;
        yTestPoints[3] = 3.0;
        LinearInterpolater linInterp = null;
        try {
            linInterp = new LinearInterpolater(xTestPoints, yTestPoints);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        for (double x = -1.0; x <= 4.0; x += 0.5) {
            System.out.println("x=" + x + ", y=" + linInterp.getPoint(x));
        }
    }
}

