/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.time;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import us.ihmc.commons.MathTools;
import us.ihmc.robotics.time.TimeIntervalProvider;
import us.ihmc.robotics.time.TimeIntervalReadOnly;

public class TimeIntervalTools {
    public static Comparator<TimeIntervalProvider> startTimeComparator = (a, b) -> {
        double startTimeA = a.getTimeInterval().getStartTime();
        double startTimeB = b.getTimeInterval().getStartTime();
        return Double.compare(startTimeA, startTimeB);
    };
    public static Comparator<TimeIntervalProvider> endTimeComparator = (a, b) -> {
        double endTimeA = a.getTimeInterval().getEndTime();
        double endTimeB = b.getTimeInterval().getEndTime();
        return Double.compare(endTimeA, endTimeB);
    };

    public static boolean areTimeIntervalsConsecutive(TimeIntervalProvider intervalA, TimeIntervalProvider intervalB) {
        return TimeIntervalTools.areTimeIntervalsConsecutive(intervalA, intervalB, 0.005);
    }

    public static boolean areTimeIntervalsConsecutive(TimeIntervalProvider intervalA, TimeIntervalProvider intervalB, double epsilon) {
        return TimeIntervalTools.areTimeIntervalsConsecutive(intervalA.getTimeInterval(), intervalB.getTimeInterval(), epsilon);
    }

    public static boolean areTimeIntervalsConsecutive(TimeIntervalReadOnly intervalA, TimeIntervalReadOnly intervalB, double epsilon) {
        return MathTools.epsilonEquals((double)intervalA.getEndTime(), (double)intervalB.getStartTime(), (double)epsilon);
    }

    public static boolean isTimeSequenceContinuous(List<? extends TimeIntervalProvider> contactStateSequence) {
        return TimeIntervalTools.isTimeSequenceContinuous(contactStateSequence, 0.005);
    }

    public static boolean isTimeSequenceContinuous(List<? extends TimeIntervalProvider> contactStateSequence, double epsilon) {
        for (int index = 0; index < contactStateSequence.size() - 1; ++index) {
            if (TimeIntervalTools.areTimeIntervalsConsecutive(contactStateSequence.get(index), contactStateSequence.get(index + 1), epsilon)) continue;
            return false;
        }
        return true;
    }

    public static boolean doIntervalsOverlap(TimeIntervalReadOnly intervalA, TimeIntervalReadOnly intervalB) {
        if (intervalA.intervalContains(intervalB.getStartTime())) {
            return true;
        }
        if (intervalA.intervalContains(intervalB.getEndTime())) {
            return true;
        }
        if (intervalB.intervalContains(intervalA.getStartTime())) {
            return true;
        }
        return intervalB.intervalContains(intervalA.getEndTime());
    }

    public static void sortByStartTime(List<? extends TimeIntervalProvider> timeIntervalProviders) {
        TimeIntervalTools.sort(timeIntervalProviders, startTimeComparator);
    }

    public static void sortByReverseStartTime(List<? extends TimeIntervalProvider> timeIntervalProviders) {
        TimeIntervalTools.sort(timeIntervalProviders, startTimeComparator.reversed());
    }

    public static void sortByEndTime(List<? extends TimeIntervalProvider> timeIntervalProviders) {
        TimeIntervalTools.sort(timeIntervalProviders, endTimeComparator);
    }

    public static void sortByReverseEndTime(List<? extends TimeIntervalProvider> timeIntervalProviders) {
        TimeIntervalTools.sort(timeIntervalProviders, endTimeComparator.reversed());
    }

    public static <T> void sort(List<T> ts, Comparator<T> comparator) {
        boolean ordered = false;
        while (!ordered) {
            ordered = true;
            for (int i = 0; i < ts.size() - 1; ++i) {
                T b;
                T a = ts.get(i);
                if (comparator.compare(a, b = ts.get(i + 1)) <= 0) continue;
                ordered = false;
                TimeIntervalTools.swap(ts, i, i + 1);
            }
        }
    }

    private static <T> void swap(List<T> ts, int a, int b) {
        T tmp = ts.get(a);
        ts.set(a, ts.get(b));
        ts.set(b, tmp);
    }

    public static void removeStartTimesLessThan(double time, List<? extends TimeIntervalProvider> timeIntervalProviders) {
        for (int i = 0; i < timeIntervalProviders.size(); ++i) {
            if (!(timeIntervalProviders.get(i).getTimeInterval().getStartTime() < time)) continue;
            timeIntervalProviders.remove(i);
            --i;
        }
    }

    public static void removeStartTimesLessThanOrEqualTo(double time, List<? extends TimeIntervalProvider> timeIntervalProviders) {
        for (int i = 0; i < timeIntervalProviders.size(); ++i) {
            if (!(timeIntervalProviders.get(i).getTimeInterval().getStartTime() <= time)) continue;
            timeIntervalProviders.remove(i);
            --i;
        }
    }

    public static void removeStartTimesGreaterThan(double time, List<? extends TimeIntervalProvider> timeIntervalProviders) {
        for (int i = timeIntervalProviders.size() - 1; i >= 0; --i) {
            if (!(timeIntervalProviders.get(i).getTimeInterval().getStartTime() > time)) continue;
            timeIntervalProviders.remove(i);
        }
    }

    public static void removeStartTimesGreaterThanOrEqualTo(double time, List<? extends TimeIntervalProvider> timeIntervalProviders) {
        for (int i = timeIntervalProviders.size() - 1; i >= 0; --i) {
            if (!(timeIntervalProviders.get(i).getTimeInterval().getStartTime() >= time)) continue;
            timeIntervalProviders.remove(i);
        }
    }

    public static void removeEndTimesLessThan(double time, List<? extends TimeIntervalProvider> timeIntervalProviders) {
        for (int i = 0; i < timeIntervalProviders.size(); ++i) {
            if (!(timeIntervalProviders.get(i).getTimeInterval().getEndTime() < time)) continue;
            timeIntervalProviders.remove(i);
            --i;
        }
    }

    public static void removeEndTimesLessThanOrEqualTo(double time, List<? extends TimeIntervalProvider> timeIntervalProviders) {
        for (int i = 0; i < timeIntervalProviders.size(); ++i) {
            if (!(timeIntervalProviders.get(i).getTimeInterval().getEndTime() <= time)) continue;
            timeIntervalProviders.remove(i);
            --i;
        }
    }

    public static void removeEndTimesGreaterThan(double time, List<? extends TimeIntervalProvider> timeIntervalProviders) {
        for (int i = timeIntervalProviders.size() - 1; i >= 0; --i) {
            if (!(timeIntervalProviders.get(i).getTimeInterval().getEndTime() > time)) continue;
            timeIntervalProviders.remove(i);
        }
    }

    public static void removeEndTimesGreaterThanOrEqualTo(double time, List<? extends TimeIntervalProvider> timeIntervalProviders) {
        for (int i = timeIntervalProviders.size() - 1; i >= 0; --i) {
            if (!(timeIntervalProviders.get(i).getTimeInterval().getEndTime() >= time)) continue;
            timeIntervalProviders.remove(i);
        }
    }

    public static <T extends TimeIntervalProvider> List<T> removeAndReturnEndTimesLessThan(double time, List<T> timeIntervalProviders) {
        ArrayList<TimeIntervalProvider> timeIntervalProvidersToRemove = new ArrayList<TimeIntervalProvider>();
        for (int i = 0; i < timeIntervalProviders.size(); ++i) {
            if (!(((TimeIntervalProvider)timeIntervalProviders.get(i)).getTimeInterval().getEndTime() < time)) continue;
            timeIntervalProvidersToRemove.add((TimeIntervalProvider)timeIntervalProviders.get(i));
        }
        return timeIntervalProvidersToRemove;
    }

    public static <T extends TimeIntervalProvider> List<T> getIntervalsContainingTime(double time, List<T> timeIntervalProviders) {
        ArrayList<TimeIntervalProvider> timeIntervalProvidersToRemove = new ArrayList<TimeIntervalProvider>();
        for (int i = 0; i < timeIntervalProviders.size(); ++i) {
            if (!((TimeIntervalProvider)timeIntervalProviders.get(i)).getTimeInterval().intervalContains(time)) continue;
            timeIntervalProvidersToRemove.add((TimeIntervalProvider)timeIntervalProviders.get(i));
        }
        return timeIntervalProvidersToRemove;
    }
}

