/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.taskExecutor;

import java.util.ArrayDeque;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.robotics.stateMachine.core.StateMachineClock;
import us.ihmc.robotics.taskExecutor.NullState;

public class StateExecutor {
    private boolean printDebugStatements;
    private State currentTask;
    private final NullState nullTask = new NullState();
    private final ArrayDeque<State> taskQueue = new ArrayDeque();
    private final StateMachineClock clock;

    public StateExecutor(StateMachineClock clock) {
        this.clock = clock;
        this.clear();
    }

    @Deprecated
    public StateExecutor() {
        this.clock = StateMachineClock.dummyClock();
        this.clear();
    }

    public void submit(State task) {
        this.taskQueue.add(task);
    }

    public void doControl() {
        this.handleTransitions();
        this.currentTask.doAction(this.clock.getTimeInCurrentState());
    }

    public void handleTransitions() {
        if (this.currentTask.isDone(this.clock.getTimeInCurrentState())) {
            this.currentTask.onExit(this.clock.getTimeInCurrentState());
            if (!this.taskQueue.isEmpty()) {
                this.currentTask = this.taskQueue.poll();
                if (this.printDebugStatements) {
                    System.out.println("+++ " + this.getClass().getSimpleName() + ": transitioning into new task:\n" + this.currentTask.toString());
                }
            } else {
                this.currentTask = this.nullTask;
            }
            this.currentTask.onEntry();
            this.clock.notifyStateChanged();
        }
    }

    public boolean isDone() {
        return this.currentTask == this.nullTask && this.taskQueue.isEmpty();
    }

    public State getCurrentTask() {
        return this.currentTask;
    }

    public State getLastTask() {
        return this.taskQueue.peekLast();
    }

    public State getNextTask() {
        return this.taskQueue.peek();
    }

    protected ArrayDeque<State> getTaskQueue() {
        return this.taskQueue;
    }

    public void clear() {
        this.currentTask = this.nullTask;
        this.taskQueue.clear();
    }

    public void clearAllExceptCurrent() {
        this.taskQueue.clear();
    }

    public void setPrintDebugStatements(boolean printDebugStatements) {
        this.printDebugStatements = printDebugStatements;
    }

    protected StateMachineClock getClock() {
        return this.clock;
    }
}

