/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.statistics;

import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class Point2DStandardDeviationCalculator {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoDouble variance;
    private final YoDouble populationVariance;
    private final YoDouble standardDeviation;
    private final YoFramePoint2D mean;
    private final YoDouble sumOfSquare;
    private final YoInteger numberOfSamples;
    private final Point2DReadOnly variable;
    private final Point2D previousMean = new Point2D();

    public Point2DStandardDeviationCalculator(String prefix, Point2DReadOnly variable, YoRegistry registry) {
        this.variable = variable;
        this.variance = new YoDouble(prefix + "_Variance", registry);
        this.populationVariance = new YoDouble(prefix + "_PopulationVariance", registry);
        this.standardDeviation = new YoDouble(prefix + "_StandardDeviation", registry);
        this.mean = new YoFramePoint2D(prefix + "_Mean", worldFrame, registry);
        this.sumOfSquare = new YoDouble(prefix + "_SumOfSquare", registry);
        this.numberOfSamples = new YoInteger(prefix + "_NumberOfSamples", registry);
    }

    public void reset() {
        this.standardDeviation.set(0.0);
        this.variance.set(0.0);
        this.mean.setToZero();
        this.sumOfSquare.set(0.0);
        this.numberOfSamples.set(0);
    }

    public void update() {
        this.previousMean.set((Tuple2DReadOnly)this.mean);
        this.numberOfSamples.increment();
        this.mean.interpolate((Tuple2DReadOnly)this.previousMean, (Tuple2DReadOnly)this.variable, 1.0 / (double)this.numberOfSamples.getIntegerValue());
        if (this.numberOfSamples.getIntegerValue() == 1) {
            this.sumOfSquare.add(this.variable.distanceSquared((Point2DReadOnly)this.mean));
            this.populationVariance.set(this.sumOfSquare.getDoubleValue() / (double)this.numberOfSamples.getIntegerValue());
            this.variance.set(this.populationVariance.getDoubleValue());
        } else {
            this.sumOfSquare.add(this.variable.distance((Point2DReadOnly)this.previousMean) * this.variable.distance((Point2DReadOnly)this.mean));
            this.populationVariance.set(this.sumOfSquare.getDoubleValue() / (double)(this.numberOfSamples.getIntegerValue() - 1));
            this.variance.set(this.sumOfSquare.getDoubleValue() / (double)this.numberOfSamples.getIntegerValue());
        }
        if (MathTools.epsilonEquals((double)this.variance.getDoubleValue(), (double)0.0, (double)1.0E-10)) {
            this.standardDeviation.set(0.0);
        } else {
            this.standardDeviation.set(Math.sqrt(this.variance.getDoubleValue()));
        }
    }

    public double getStandardDeviation() {
        return this.standardDeviation.getDoubleValue();
    }

    public double getVariance() {
        return this.variance.getDoubleValue();
    }

    public Point2DReadOnly getMean() {
        return this.mean;
    }
}

