/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.statistics;

import us.ihmc.commons.MathTools;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class OnlineStandardDeviationCalculator {
    private final YoDouble variance;
    private final YoDouble populationVariance;
    private final YoDouble standardDeviation;
    private final YoDouble mean;
    private final YoDouble sumOfSquare;
    private final YoInteger numberOfSamples;
    private final DoubleProvider variable;

    public OnlineStandardDeviationCalculator(String prefix, YoRegistry registry) {
        this(prefix, null, registry);
    }

    public OnlineStandardDeviationCalculator(String prefix, DoubleProvider variable, YoRegistry registry) {
        this.variable = variable;
        this.variance = new YoDouble(prefix + "_Variance", registry);
        this.populationVariance = new YoDouble(prefix + "_PopulationVariance", registry);
        this.standardDeviation = new YoDouble(prefix + "_StandardDeviation", registry);
        this.mean = new YoDouble(prefix + "_Mean", registry);
        this.sumOfSquare = new YoDouble(prefix + "_SumOfSquare", registry);
        this.numberOfSamples = new YoInteger(prefix + "_NumberOfSamples", registry);
    }

    public void reset() {
        this.standardDeviation.set(0.0);
        this.variance.set(0.0);
        this.mean.set(0.0);
        this.sumOfSquare.set(0.0);
        this.numberOfSamples.set(0);
    }

    public void update() {
        if (this.variable == null) {
            throw new RuntimeException("Variable was never set.");
        }
        this.update(this.variable.getValue());
    }

    public void update(double variableValue) {
        double totalValue = (double)this.numberOfSamples.getIntegerValue() * this.mean.getDoubleValue();
        double previousMean = this.mean.getDoubleValue();
        this.numberOfSamples.increment();
        this.mean.set((totalValue += variableValue) / (double)this.numberOfSamples.getIntegerValue());
        if (this.numberOfSamples.getIntegerValue() == 1) {
            this.sumOfSquare.add(MathTools.square((double)(variableValue - this.mean.getDoubleValue())));
            this.populationVariance.set(this.sumOfSquare.getDoubleValue() / (double)this.numberOfSamples.getIntegerValue());
            this.variance.set(this.populationVariance.getDoubleValue());
        } else {
            this.sumOfSquare.add((variableValue - previousMean) * (variableValue - this.mean.getDoubleValue()));
            this.populationVariance.set(this.sumOfSquare.getDoubleValue() / (double)(this.numberOfSamples.getIntegerValue() - 1));
            this.variance.set(this.sumOfSquare.getDoubleValue() / (double)this.numberOfSamples.getIntegerValue());
        }
        if (this.numberOfSamples.getValue() < 2) {
            this.standardDeviation.set(0.0);
        } else {
            this.standardDeviation.set(Math.sqrt(this.variance.getDoubleValue()));
        }
    }

    public int getNumberOfSamples() {
        return this.numberOfSamples.getIntegerValue();
    }

    public double getStandardDeviation() {
        return this.standardDeviation.getDoubleValue();
    }

    public double getVariance() {
        return this.variance.getDoubleValue();
    }

    public double getMean() {
        return this.mean.getDoubleValue();
    }
}

