/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.statistics;

import us.ihmc.robotics.statistics.OnlineStandardDeviationCalculator;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class OnlineCovarianceCalculator {
    private final YoDouble coMoment;
    private final YoDouble correlation;
    private final YoDouble covariance;
    private final OnlineStandardDeviationCalculator xCalculator;
    private final OnlineStandardDeviationCalculator yCalculator;

    public OnlineCovarianceCalculator(String prefix, YoRegistry registry) {
        this.coMoment = new YoDouble(prefix + "_CoMoment", registry);
        this.covariance = new YoDouble(prefix + "_Covariance", registry);
        this.correlation = new YoDouble(prefix + "_Correlation", registry);
        this.xCalculator = new OnlineStandardDeviationCalculator(prefix + "X", registry);
        this.yCalculator = new OnlineStandardDeviationCalculator(prefix + "Y", registry);
    }

    public void reset() {
        this.coMoment.set(0.0);
        this.correlation.set(0.0);
        this.covariance.set(0.0);
        this.xCalculator.reset();
        this.yCalculator.reset();
    }

    public void update(double x, double y) {
        double xError = x - this.xCalculator.getMean();
        this.xCalculator.update(x);
        this.yCalculator.update(y);
        this.coMoment.add(xError * (y - this.yCalculator.getMean()));
        this.covariance.set(this.coMoment.getDoubleValue() / (double)this.xCalculator.getNumberOfSamples());
        this.correlation.set(this.covariance.getDoubleValue() / (this.xCalculator.getStandardDeviation() * this.yCalculator.getStandardDeviation()));
    }

    public double getCorrelation() {
        return this.correlation.getDoubleValue();
    }

    public double getXStandardDeviation() {
        return this.xCalculator.getStandardDeviation();
    }

    public double getYStandardDeviation() {
        return this.yCalculator.getStandardDeviation();
    }

    public double getXMean() {
        return this.xCalculator.getMean();
    }

    public double getYMean() {
        return this.yCalculator.getMean();
    }
}

