/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.statistics;

import us.ihmc.commons.MathTools;

public class OnePassMeanAndStandardDeviation {
    private int k = 0;
    private double sum;
    private double mK;
    private double qK;

    public void compute(double value) {
        if (this.k == 0) {
            this.computeFirst(value);
        } else {
            this.computeOther(value);
        }
    }

    private void computeFirst(double value) {
        this.k = 1;
        this.sum = value;
        this.qK = 0.0;
        this.mK = value;
    }

    private void computeOther(double value) {
        ++this.k;
        this.sum += value;
        double mKLast = this.mK;
        double kDouble = this.k;
        this.mK = mKLast + (value - mKLast) / kDouble;
        this.qK += (kDouble - 1.0) * MathTools.square((double)(value - mKLast)) / kDouble;
    }

    public int getNumberOfTotalMeasurements() {
        int n = this.k;
        return n;
    }

    public double getAverage() {
        if (this.k == 0) {
            throw new InsufficientMeasurementsException("Average can not be defined, needs at least 1 measurment.");
        }
        double mu = this.sum / (double)this.k;
        return mu;
    }

    public double getVariance() {
        if (this.k == 0) {
            throw new InsufficientMeasurementsException("Variance can not be defined, needs at least 1 measurment.");
        }
        double sigmaSquare = this.qK / (double)this.k;
        return sigmaSquare;
    }

    public double getStandardDeviation() {
        double sigma = Math.sqrt(this.getVariance());
        return sigma;
    }

    public double getSampleVariance() {
        if (this.k <= 1) {
            throw new InsufficientMeasurementsException("SampleVariance can not be defined, needs at least 2 measurments.");
        }
        double sSquare = this.qK / (double)(this.k - 1);
        return sSquare;
    }

    class InsufficientMeasurementsException
    extends RuntimeException {
        private static final long serialVersionUID = 6173538739891490316L;

        public InsufficientMeasurementsException(String string) {
            super(string);
        }
    }
}

