/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.stateMachine.extra;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import java.util.function.Supplier;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.robotics.stateMachine.core.StateTransitionCondition;
import us.ihmc.robotics.stateMachine.extra.MutableState;
import us.ihmc.robotics.stateMachine.extra.StateTransitionTo;
import us.ihmc.robotics.stateMachine.factories.StateMachineFactory;
import us.ihmc.yoVariables.registry.YoRegistry;

public class EnumBasedStateMachineFactory<K extends Enum<K>> {
    private final Class<K> keyType;
    private final StateMachineFactory<K, State> factory;
    private final HashMap<K, MutableState> stateMap;

    public EnumBasedStateMachineFactory(Class<K> keyType) {
        this.factory = new StateMachineFactory(keyType);
        this.keyType = keyType;
        String name = keyType.getSimpleName() + "Machine";
        this.getFactory().setNamePrefix(name).setRegistry(new YoRegistry(name + "Registry"));
        this.stateMap = new HashMap();
        for (Enum value : EnumSet.allOf(keyType)) {
            MutableState mutableState = new MutableState();
            this.getFactory().addState(value, mutableState);
            this.getStateMap().put(value, mutableState);
        }
    }

    public void addTransition(K from, K to, StateTransitionCondition condition) {
        this.getFactory().addTransition(from, to, condition);
    }

    public void addTransition(K from, K to, BooleanSupplier condition) {
        this.getFactory().addTransition(from, to, (double timeInCurrentState) -> condition.getAsBoolean());
    }

    public void addTransition(K from, List<K> toOptions, Supplier<K> stateTransitionTo) {
        this.addTransition(from, toOptions, (double timeInCurrentState) -> (Enum)stateTransitionTo.get());
    }

    public void addTransition(K from, List<K> toOptions, StateTransitionTo<K> stateTransitionTo) {
        for (Enum value : toOptions) {
            this.factory.addTransition((Enum)from, value, (double timeInState) -> {
                Enum transitionTo = (Enum)stateTransitionTo.shouldTransitionTo(timeInState);
                if (transitionTo != null && !toOptions.contains(transitionTo)) {
                    throw new RuntimeException("Invalid transition to " + transitionTo + ". Options are " + toOptions);
                }
                if (transitionTo == value) {
                    LogTools.debug((String)"Transition {} -> {}", (Object)from.name(), (Object)transitionTo.name());
                }
                return transitionTo == value;
            });
        }
    }

    public StateMachineFactory<K, State> getFactory() {
        return this.factory;
    }

    public HashMap<K, MutableState> getStateMap() {
        return this.stateMap;
    }

    public MutableState getState(K stateEnum) {
        return this.stateMap.get(stateEnum);
    }

    public void setOnEntry(K key, Runnable onEntry) {
        this.getState(key).setOnEntry(onEntry);
    }

    public void setDoAction(K key, Runnable doAction) {
        this.setDoAction(key, (double timeInCurrentState) -> doAction.run());
    }

    public void setDoAction(K key, DoubleConsumer doAction) {
        this.getState(key).setDoAction(doAction);
    }

    public void setOnExit(K key, Runnable onExit) {
        this.getState(key).setOnExit(onExit);
    }

    public void setIsDone(K key, DoublePredicate isDone) {
        this.getState(key).setIsDone(isDone);
    }
}

