/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.stateMachine.core;

import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public interface StateMachineClock {
    public void notifyStateChanged();

    public double getTime();

    public double getTimeInCurrentState();

    public double getTimeOfLastStateChange();

    public static StateMachineClock dummyClock() {
        return new StateMachineClock(){

            @Override
            public void notifyStateChanged() {
            }

            @Override
            public double getTime() {
                return Double.NaN;
            }

            @Override
            public double getTimeInCurrentState() {
                return Double.NaN;
            }

            @Override
            public double getTimeOfLastStateChange() {
                return Double.NaN;
            }
        };
    }

    public static StateMachineClock clock(final DoubleProvider timeProvider) {
        return new StateMachineClock(){
            double timeOfLastStateChange = Double.NaN;

            @Override
            public void notifyStateChanged() {
                this.timeOfLastStateChange = timeProvider.getValue();
            }

            @Override
            public double getTime() {
                return timeProvider.getValue();
            }

            @Override
            public double getTimeInCurrentState() {
                return timeProvider.getValue() - this.timeOfLastStateChange;
            }

            @Override
            public double getTimeOfLastStateChange() {
                return this.timeOfLastStateChange;
            }
        };
    }

    public static StateMachineClock yoClock(final DoubleProvider timeProvider, String namePrefix, YoRegistry registry) {
        final YoDouble timeOfLastStateChange = new YoDouble(namePrefix + "SwitchTime", "Time at which the last state change occured.", registry);
        final YoDouble timeInCurrentState = new YoDouble(namePrefix + "StateTime", "Time relative to the start of the current state.", registry);
        timeOfLastStateChange.setToNaN();
        timeInCurrentState.setToNaN();
        return new StateMachineClock(){

            @Override
            public void notifyStateChanged() {
                timeOfLastStateChange.set(timeProvider.getValue());
            }

            @Override
            public double getTime() {
                return timeProvider.getValue();
            }

            @Override
            public double getTimeInCurrentState() {
                double t = timeProvider.getValue() - timeOfLastStateChange.getDoubleValue();
                timeInCurrentState.set(t);
                return t;
            }

            @Override
            public double getTimeOfLastStateChange() {
                return timeOfLastStateChange.getDoubleValue();
            }
        };
    }
}

