/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.sliderboard;

import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;
import us.ihmc.commons.MathTools;

public class SliderboardTools {
    public static final byte CONTROL_BYTE = 11;
    public static final byte CHANNEL_ZERO = 0;
    public static final short STATUS = 176;
    public static final int MAX_VALUE = 127;

    public static double toSliderPercent(int dataByte) {
        return MathTools.clamp((double)((double)dataByte / 127.0), (double)0.0, (double)1.0);
    }

    public static boolean toButtonStatus(int dataByte) {
        return dataByte == 127;
    }

    public static int toDataByte(double sliderPercent) {
        return (int)(127.0 * MathTools.clamp((double)sliderPercent, (double)0.0, (double)1.0));
    }

    public static int toDataByte(boolean status) {
        return status ? 127 : 0;
    }

    public static boolean infoMatchesSliderboard(MidiDevice.Info info, String sliderBoardName) {
        String name = info.getName();
        String description = info.getDescription();
        return name.contains(sliderBoardName) || description.contains(sliderBoardName);
    }

    public static Transmitter getTransmitter(MidiDevice current) {
        if (current.getMaxTransmitters() != 0) {
            try {
                if (!current.isOpen()) {
                    current.open();
                }
            }
            catch (MidiUnavailableException e) {
                return null;
            }
            try {
                return current.getTransmitter();
            }
            catch (MidiUnavailableException e) {
                current.close();
            }
        }
        return null;
    }

    public static Receiver getReceiver(MidiDevice current) {
        if (current.getMaxReceivers() != 0) {
            try {
                if (!current.isOpen()) {
                    current.open();
                }
            }
            catch (MidiUnavailableException e) {
                return null;
            }
            try {
                return current.getReceiver();
            }
            catch (MidiUnavailableException e) {
                current.close();
            }
        }
        return null;
    }
}

