/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.sliderboard;

import us.ihmc.commons.Conversions;
import us.ihmc.commons.PrintTools;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.robotics.sliderboard.ButtonListener;
import us.ihmc.robotics.sliderboard.Sliderboard;
import us.ihmc.robotics.sliderboard.SliderboardListener;

public class SliderboardDemo {
    private static final int buttons = 16;
    private static final int sliders = 16;

    public static void main(String[] args) {
        Sliderboard sliderboard = new Sliderboard();
        if (!sliderboard.isConnected()) {
            return;
        }
        for (int slider = 1; slider <= 16; ++slider) {
            final int sliderIndex = slider;
            sliderboard.addListener(new SliderboardListener(){

                @Override
                public void sliderMoved(double sliderPercentage) {
                    PrintTools.info((String)("Slider " + sliderIndex + " moved to: " + sliderPercentage));
                }
            }, slider);
            sliderboard.setSliderValue(0.0, sliderIndex);
        }
        for (int button = 1; button <= 16; ++button) {
            final int buttonIndex = button;
            sliderboard.addListener(new ButtonListener(){

                @Override
                public void buttonPressed(boolean status) {
                    PrintTools.info((String)("Button " + buttonIndex + " pushed: " + status));
                }
            }, button);
        }
        SliderboardDemo.goToZero(sliderboard);
        double dt = 0.05;
        double totalTime = 5.0;
        int button = 1;
        for (double time = 0.0; time < totalTime; time += dt) {
            for (int slider = 1; slider <= 16; ++slider) {
                double phase = Math.PI * (double)slider / 16.0 + Math.PI;
                sliderboard.setSliderValue(Math.max(Math.sin(time * 2.0 * Math.PI / totalTime + phase), 0.0), slider);
            }
            sliderboard.setButtonValue(false, button - 1 == 0 ? 16 : button - 1);
            sliderboard.setButtonValue(true, button);
            button = button == 16 ? 1 : button + 1;
            ThreadTools.sleep((long)((int)Conversions.secondsToMilliseconds((double)dt)));
        }
        SliderboardDemo.goToZero(sliderboard);
        sliderboard.close();
    }

    private static void goToZero(Sliderboard sliderboard) {
        for (int button = 1; button <= 16; ++button) {
            sliderboard.setButtonValue(false, button);
        }
        for (int slider = 1; slider <= 16; ++slider) {
            sliderboard.setSliderValue(0.0, slider);
        }
        ThreadTools.sleep((long)100L);
    }
}

