/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.sliderboard;

import gnu.trove.map.TIntDoubleMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntDoubleHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TObjectProcedure;
import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import us.ihmc.commons.PrintTools;
import us.ihmc.robotics.sliderboard.ButtonListener;
import us.ihmc.robotics.sliderboard.MidiControlMap;
import us.ihmc.robotics.sliderboard.SliderboardListener;
import us.ihmc.robotics.sliderboard.SliderboardTools;

public class SliderboardDataReciever
implements Receiver {
    private final MidiControlMap channelMapper;
    private final TIntObjectMap<List<SliderboardListener>> sliderListeners = new TIntObjectHashMap();
    private final TIntObjectMap<List<ButtonListener>> buttonListeners = new TIntObjectHashMap();
    private final TIntDoubleMap sliderValues = new TIntDoubleHashMap();

    public SliderboardDataReciever(MidiControlMap channelMapper) {
        this.channelMapper = channelMapper;
    }

    @Override
    public void send(MidiMessage message, long timeStamp) {
        if (!(message instanceof ShortMessage)) {
            return;
        }
        ShortMessage shortMessage = (ShortMessage)message;
        if (shortMessage.getCommand() != 176) {
            return;
        }
        int midiChannel = shortMessage.getData1();
        if (this.channelMapper.getSliderIndex(midiChannel) != -1) {
            this.handleSliderInput(this.channelMapper.getSliderIndex(midiChannel), shortMessage.getData2());
        } else if (this.channelMapper.getButtonIndex(midiChannel) != -1) {
            this.handleButtonInput(this.channelMapper.getButtonIndex(midiChannel), shortMessage.getData2());
        } else if (this.channelMapper.getDelayVariationChannel() == midiChannel) {
            PrintTools.info((String)"Got a 'Delay/Variation Send' message.");
        } else {
            PrintTools.info((String)("Unknown controller: " + midiChannel + " - " + shortMessage.getData2()));
            return;
        }
    }

    private void handleSliderInput(int sliderIndex, int data) {
        double previousValue;
        double value = SliderboardTools.toSliderPercent(data);
        List listeners = (List)this.sliderListeners.get(sliderIndex);
        double d = previousValue = this.sliderValues.containsKey(sliderIndex) ? this.sliderValues.get(sliderIndex) : -1.0;
        if (listeners != null && previousValue != value) {
            listeners.forEach(listener -> listener.sliderMoved(value));
        }
        this.sliderValues.put(sliderIndex, value);
    }

    private void handleButtonInput(int buttonIndex, int data) {
        boolean status = SliderboardTools.toButtonStatus(data);
        List listeners = (List)this.buttonListeners.get(buttonIndex);
        if (listeners != null) {
            listeners.forEach(listener -> listener.buttonPressed(status));
        }
    }

    public boolean addListener(SliderboardListener sliderListener, int sliderIndex) {
        if (this.channelMapper.getSliderChannel(sliderIndex) == -1) {
            return false;
        }
        if (!this.sliderListeners.containsKey(sliderIndex)) {
            this.sliderListeners.put(sliderIndex, new ArrayList());
        }
        ((List)this.sliderListeners.get(sliderIndex)).add(sliderListener);
        return true;
    }

    public boolean addListener(ButtonListener buttonListener, int buttonIndex) {
        if (this.channelMapper.getButtonChannel(buttonIndex) == -1) {
            return false;
        }
        if (!this.buttonListeners.containsKey(buttonIndex)) {
            this.buttonListeners.put(buttonIndex, new ArrayList());
        }
        ((List)this.buttonListeners.get(buttonIndex)).add(buttonListener);
        return true;
    }

    public void clearListeners() {
        this.sliderListeners.forEachValue((TObjectProcedure)new TObjectProcedure<List<SliderboardListener>>(){

            public boolean execute(List<SliderboardListener> listenerList) {
                listenerList.clear();
                return true;
            }
        });
        this.buttonListeners.forEachValue((TObjectProcedure)new TObjectProcedure<List<ButtonListener>>(){

            public boolean execute(List<ButtonListener> listenerList) {
                listenerList.clear();
                return true;
            }
        });
    }

    public void removeListener(SliderboardListener sliderListener, int sliderIndex) {
        if (this.sliderListeners.containsKey(sliderIndex)) {
            ((List)this.sliderListeners.get(sliderIndex)).remove(sliderListener);
        }
    }

    public void removeListener(ButtonListener buttonListener, int buttonIndex) {
        if (this.buttonListeners.containsKey(buttonIndex)) {
            ((List)this.buttonListeners.get(buttonIndex)).remove(buttonListener);
        }
    }

    @Override
    public void close() {
    }
}

