/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.sliderboard;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;
import us.ihmc.commons.PrintTools;
import us.ihmc.robotics.sliderboard.ButtonListener;
import us.ihmc.robotics.sliderboard.MidiControlMap;
import us.ihmc.robotics.sliderboard.SliderboardDataReciever;
import us.ihmc.robotics.sliderboard.SliderboardListener;
import us.ihmc.robotics.sliderboard.SliderboardTools;
import us.ihmc.robotics.sliderboard.boards.SliderboardType;

public class Sliderboard {
    private static final SliderboardType sliderboardType = SliderboardType.findConnectedSliderBoard();
    private final MidiControlMap channelMapper;
    private final SliderboardDataReciever sliderboardDataReciever;
    private MidiDevice outDevice;
    private MidiDevice inDevice;
    private Receiver receiver;
    private Transmitter transmitter;

    public Sliderboard() {
        if (sliderboardType == null) {
            this.channelMapper = null;
            this.sliderboardDataReciever = null;
            return;
        }
        this.channelMapper = sliderboardType.getChannelMapper();
        this.sliderboardDataReciever = new SliderboardDataReciever(this.channelMapper);
        for (MidiDevice.Info info : MidiSystem.getMidiDeviceInfo()) {
            if (!SliderboardTools.infoMatchesSliderboard(info, sliderboardType.getStringIdentifier())) continue;
            try {
                MidiDevice current = MidiSystem.getMidiDevice(info);
                if (this.receiver == null && (this.receiver = SliderboardTools.getReceiver(current)) != null) {
                    this.outDevice = current;
                }
                if (this.transmitter != null || (this.transmitter = SliderboardTools.getTransmitter(current)) == null) continue;
                this.inDevice = current;
            }
            catch (MidiUnavailableException e) {
                // empty catch block
            }
        }
        if (!this.isConnected()) {
            this.close();
            return;
        }
        this.transmitter.setReceiver(this.sliderboardDataReciever);
    }

    public void close() {
        if (this.receiver != null) {
            this.receiver.close();
            this.receiver = null;
        }
        if (this.transmitter != null) {
            this.transmitter.close();
            this.transmitter = null;
        }
        if (this.outDevice != null) {
            this.outDevice.close();
            this.outDevice = null;
        }
        if (this.inDevice != null) {
            this.inDevice.close();
            this.inDevice = null;
        }
    }

    public boolean isConnected() {
        return this.receiver != null && this.transmitter != null && this.outDevice != null && this.inDevice != null && this.outDevice.isOpen() && this.inDevice.isOpen();
    }

    public boolean addListener(SliderboardListener sliderListener, int sliderIndex) {
        if (!this.isConnected()) {
            return false;
        }
        return this.sliderboardDataReciever.addListener(sliderListener, sliderIndex);
    }

    public boolean addListener(ButtonListener buttonListener, int buttonIndex) {
        if (!this.isConnected()) {
            return false;
        }
        return this.sliderboardDataReciever.addListener(buttonListener, buttonIndex);
    }

    public void setSliderValue(double sliderPercent, int sliderIndex) {
        if (!this.isConnected()) {
            return;
        }
        int channel = this.channelMapper.getSliderChannel(sliderIndex);
        if (channel == -1) {
            PrintTools.info((String)("Unknown slider index: " + sliderIndex));
            return;
        }
        try {
            ShortMessage message = new ShortMessage();
            int data = SliderboardTools.toDataByte(sliderPercent);
            message.setMessage(176, channel, data);
            this.receiver.send(message, -1L);
        }
        catch (InvalidMidiDataException e) {
            PrintTools.info((String)"Was unable to create slider board message.");
        }
    }

    public void setButtonValue(boolean status, int buttonIndex) {
        if (!this.isConnected()) {
            return;
        }
        int channel = this.channelMapper.getButtonChannel(buttonIndex);
        if (channel == -1) {
            PrintTools.info((String)("Unknown button index: " + buttonIndex));
            return;
        }
        try {
            ShortMessage message = new ShortMessage();
            int data = SliderboardTools.toDataByte(status);
            message.setMessage(176, channel, data);
            this.receiver.send(message, -1L);
        }
        catch (InvalidMidiDataException e) {
            PrintTools.info((String)"Was unable to create slider board message.");
        }
    }

    public void clearListeners() {
        this.sliderboardDataReciever.clearListeners();
    }

    public void removeListener(SliderboardListener sliderListener, int sliderIndex) {
        this.sliderboardDataReciever.removeListener(sliderListener, sliderIndex);
    }

    public void removeListener(ButtonListener buttonListener, int buttonIndex) {
        this.sliderboardDataReciever.removeListener(buttonListener, buttonIndex);
    }
}

