/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.sensors;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;

public class IMUDefinition {
    private final String name;
    private final RigidBodyBasics rigidBody;
    private final RigidBodyTransform transformFromIMUToJoint;
    private final ReferenceFrame imuFrame;

    public IMUDefinition(String name, RigidBodyBasics rigidBody, RigidBodyTransformReadOnly transformFromIMUToJoint) {
        this.name = name;
        this.rigidBody = rigidBody;
        this.transformFromIMUToJoint = new RigidBodyTransform(transformFromIMUToJoint);
        MovingReferenceFrame frameAfterJoint = rigidBody.getParentJoint().getFrameAfterJoint();
        this.imuFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)name, (ReferenceFrame)frameAfterJoint, (RigidBodyTransformReadOnly)transformFromIMUToJoint);
    }

    public String getName() {
        return this.name;
    }

    public RigidBodyBasics getRigidBody() {
        return this.rigidBody;
    }

    public RigidBodyTransformReadOnly getTransformFromIMUToJoint() {
        return this.transformFromIMUToJoint;
    }

    public ReferenceFrame getIMUFrame() {
        return this.imuFrame;
    }

    public String toString() {
        return "IMUDefinition: " + this.name + " attached to " + this.rigidBody.getName();
    }
}

