/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.sensors;

import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.screwTheory.GenericCRC32;
import us.ihmc.robotics.sensors.CenterOfMassDataHolderReadOnly;

public class CenterOfMassDataHolder
implements CenterOfMassDataHolderReadOnly {
    private boolean hasPosition = false;
    private boolean hasVelocity = false;
    private final FramePoint3D centerOfMassPosition = new FramePoint3D();
    private final FrameVector3D centerOfMassVelocity = new FrameVector3D();

    public CenterOfMassDataHolder() {
        this.clear();
    }

    public void clear() {
        this.hasPosition = false;
        this.hasVelocity = false;
        this.centerOfMassPosition.setToNaN();
        this.centerOfMassVelocity.setToNaN();
    }

    public void setCenterOfMassPosition(ReferenceFrame referenceFrame, Point3DReadOnly centerOfMassPosition) {
        this.hasPosition = true;
        this.centerOfMassPosition.setIncludingFrame(referenceFrame, (Tuple3DReadOnly)centerOfMassPosition);
    }

    public void setCenterOfMassPosition(FramePoint3DReadOnly centerOfMassPosition) {
        this.setCenterOfMassPosition(centerOfMassPosition.getReferenceFrame(), (Point3DReadOnly)centerOfMassPosition);
    }

    public void setCenterOfMassVelocity(ReferenceFrame referenceFrame, Vector3DReadOnly centerOfMassVelocity) {
        this.hasVelocity = true;
        this.centerOfMassVelocity.setIncludingFrame(referenceFrame, (Tuple3DReadOnly)centerOfMassVelocity);
    }

    public void setCenterOfMassVelocity(FrameVector3DReadOnly centerOfMassVelocity) {
        this.setCenterOfMassVelocity(centerOfMassVelocity.getReferenceFrame(), (Vector3DReadOnly)centerOfMassVelocity);
    }

    public void set(CenterOfMassDataHolder other) {
        this.hasPosition = other.hasPosition;
        this.hasVelocity = other.hasVelocity;
        this.centerOfMassPosition.setIncludingFrame((FrameTuple3DReadOnly)other.centerOfMassPosition);
        this.centerOfMassVelocity.setIncludingFrame((FrameTuple3DReadOnly)other.centerOfMassVelocity);
    }

    public void setHasCenterOfMassPosition(boolean hasPosition) {
        this.hasPosition = hasPosition;
    }

    public void setHasCenterOfMassVelocity(boolean hasVelocity) {
        this.hasVelocity = hasVelocity;
    }

    @Override
    public boolean hasCenterOfMassPosition() {
        return this.hasPosition;
    }

    public FramePoint3D getCenterOfMassPosition() {
        return this.centerOfMassPosition;
    }

    @Override
    public boolean hasCenterOfMassVelocity() {
        return this.hasVelocity;
    }

    public FrameVector3D getCenterOfMassVelocity() {
        return this.centerOfMassVelocity;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CenterOfMassDataHolder) {
            CenterOfMassDataHolder other = (CenterOfMassDataHolder)object;
            if (this.hasPosition != other.hasPosition) {
                return false;
            }
            if (this.hasVelocity != other.hasVelocity) {
                return false;
            }
            if (this.hasCenterOfMassPosition() && !this.centerOfMassPosition.equals((EuclidFrameGeometry)other.centerOfMassPosition)) {
                return false;
            }
            return !this.hasCenterOfMassVelocity() || this.centerOfMassVelocity.equals((EuclidFrameGeometry)other.centerOfMassVelocity);
        }
        return false;
    }

    public void calculateChecksum(GenericCRC32 checksum) {
        checksum.update(this.hasPosition);
        checksum.update(this.hasVelocity);
        checksum.update((Tuple3DReadOnly)this.centerOfMassPosition);
        checksum.update((Tuple3DReadOnly)this.centerOfMassVelocity);
    }
}

