/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import java.util.stream.Stream;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicEllipsoid;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.SpatialInertia;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;
import us.ihmc.robotics.screwTheory.Matrix3DEigenValueCalculator;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoseUsingYawPitchRoll;

public class WholeBodyInertiaCalculator {
    private final RigidBodyBasics[] rigidBodiesInOrders;
    private final SpatialInertia tempInertia = new SpatialInertia();
    private final ReferenceFrame centerOfMassFrame;
    private final SpatialInertia wholeBodyInertia = new SpatialInertia();
    private final Matrix3DEigenValueCalculator eigenValueCalculator = new Matrix3DEigenValueCalculator();
    private final YoFramePoseUsingYawPitchRoll comPose;
    private final YoGraphicEllipsoid inertiaEllipsoid;
    private final Vector3D radii = new Vector3D();

    public WholeBodyInertiaCalculator(ReferenceFrame centerOfMassFrame, YoGraphicsListRegistry graphicsListRegistry, RigidBodyBasics ... rigidBodies) {
        this.centerOfMassFrame = centerOfMassFrame;
        this.rigidBodiesInOrders = (RigidBodyBasics[])Stream.of(rigidBodies).filter(body -> body.getInertia() != null).toArray(RigidBodyBasics[]::new);
        AppearanceDefinition appearance = YoAppearance.Green();
        appearance.setTransparency(0.5);
        this.comPose = new YoFramePoseUsingYawPitchRoll("comPose", ReferenceFrame.getWorldFrame(), null);
        if (graphicsListRegistry != null) {
            this.inertiaEllipsoid = new YoGraphicEllipsoid("inertiaEllipse", this.comPose, appearance, (Vector3DReadOnly)this.radii);
            graphicsListRegistry.registerYoGraphic("WholeBodyInertia", (YoGraphic)this.inertiaEllipsoid);
        } else {
            this.inertiaEllipsoid = null;
        }
    }

    public WholeBodyInertiaCalculator(ReferenceFrame centerOfMassFrame, YoGraphicsListRegistry graphicsListRegistry, RigidBodyBasics rootBody) {
        this(centerOfMassFrame, graphicsListRegistry, rootBody.subtreeArray());
    }

    public void computeAndPack(SpatialInertiaBasics wholeBodyInertia) {
        this.compute();
        wholeBodyInertia.setIncludingFrame((SpatialInertiaReadOnly)this.wholeBodyInertia);
    }

    public void compute() {
        this.wholeBodyInertia.setToZero(this.centerOfMassFrame, this.centerOfMassFrame);
        for (RigidBodyBasics rigidBody : this.rigidBodiesInOrders) {
            this.tempInertia.setIncludingFrame((SpatialInertiaReadOnly)rigidBody.getInertia());
            this.tempInertia.changeFrame(this.centerOfMassFrame);
            this.wholeBodyInertia.add((SpatialInertiaReadOnly)this.tempInertia);
        }
        if (this.inertiaEllipsoid != null) {
            this.updateVisualizer();
        }
    }

    public SpatialInertiaReadOnly getWholeBodyInertia() {
        return this.wholeBodyInertia;
    }

    private void updateVisualizer() {
        this.comPose.setFromReferenceFrame(this.centerOfMassFrame);
        this.eigenValueCalculator.compute((Matrix3DReadOnly)this.wholeBodyInertia.getMomentOfInertia());
        double meanDensity = 1000.0;
        double numerator = Math.pow(this.eigenValueCalculator.getFirstEigenValue() * this.eigenValueCalculator.getSecondEigenValue() * this.eigenValueCalculator.getThirdEigenValue(), 0.4);
        double constDenominator = Math.pow(Math.PI * 8 * meanDensity / 15.0, 0.2);
        double axis1 = numerator / (this.eigenValueCalculator.getFirstEigenValue() * constDenominator);
        double axis2 = numerator / (this.eigenValueCalculator.getSecondEigenValue() * constDenominator);
        double axis3 = numerator / (this.eigenValueCalculator.getThirdEigenValue() * constDenominator);
        this.radii.set(axis1, axis2, axis3);
        this.inertiaEllipsoid.setRadii(this.radii);
    }
}

