/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;

public class MovingMidFrameZUpFrame
extends MovingReferenceFrame {
    private final MovingReferenceFrame frameOne;
    private final MovingReferenceFrame frameTwo;
    private final FramePoint3D originOne = new FramePoint3D();
    private final FramePoint3D originTwo = new FramePoint3D();
    private final FrameVector3D vectorBetweenFrames = new FrameVector3D();
    private final Vector2D xAxis = new Vector2D();
    private final Vector3D translation = new Vector3D();
    private final FrameVector3D linearVelocity = new FrameVector3D();
    private final FrameVector3D linearVelocityOne = new FrameVector3D();
    private final FrameVector3D linearVelocityTwo = new FrameVector3D();

    public MovingMidFrameZUpFrame(String name, MovingReferenceFrame frameOne, MovingReferenceFrame frameTwo) {
        super(name, frameOne.getRootFrame(), true);
        if (frameOne == frameTwo) {
            throw new IllegalArgumentException("The frames have to be different.");
        }
        frameOne.verifySameRoots((ReferenceFrame)frameTwo);
        this.frameOne = frameOne;
        this.frameTwo = frameTwo;
    }

    public MovingMidFrameZUpFrame(String name, MovingReferenceFrame frameOne, MovingReferenceFrame frameTwo, ReferenceFrame stationaryFrame) {
        super(name, stationaryFrame, true);
        if (frameOne == frameTwo) {
            throw new IllegalArgumentException("The frames have to be different.");
        }
        if (!stationaryFrame.isAStationaryFrame()) {
            throw new RuntimeException(((Object)((Object)this)).getClass().getSimpleName() + " can only have a root frame that is stationary.");
        }
        frameOne.verifyIsAncestor(stationaryFrame);
        frameTwo.verifyIsAncestor(stationaryFrame);
        this.frameOne = frameOne;
        this.frameTwo = frameTwo;
    }

    protected void updateTransformToParent(RigidBodyTransform transformToParent) {
        this.originOne.setToZero((ReferenceFrame)this.frameOne);
        this.originOne.changeFrame(this.getParent());
        this.originTwo.setToZero((ReferenceFrame)this.frameTwo);
        this.originTwo.changeFrame(this.getParent());
        this.translation.interpolate((Tuple3DReadOnly)this.originOne, (Tuple3DReadOnly)this.originTwo, 0.5);
        transformToParent.getTranslation().set((Tuple3DReadOnly)this.translation);
        this.vectorBetweenFrames.setToZero(this.getParent());
        this.vectorBetweenFrames.sub((FrameTuple3DReadOnly)this.originTwo, (FrameTuple3DReadOnly)this.originOne);
        this.xAxis.set(-this.vectorBetweenFrames.getY(), this.vectorBetweenFrames.getX());
        if (this.xAxis.lengthSquared() < 1.0E-7) {
            return;
        }
        this.xAxis.normalize();
        transformToParent.getRotation().setToYawOrientation(Math.atan2(this.xAxis.getY(), this.xAxis.getX()));
    }

    protected void updateTwistRelativeToParent(Twist twistRelativeToParentToPack) {
        TwistReadOnly twistOfFrameOne = this.frameOne.getTwistOfFrame();
        TwistReadOnly twistOfFrameTwo = this.frameTwo.getTwistOfFrame();
        this.linearVelocityOne.setIncludingFrame((FrameTuple3DReadOnly)twistOfFrameOne.getLinearPart());
        this.linearVelocityTwo.setIncludingFrame((FrameTuple3DReadOnly)twistOfFrameTwo.getLinearPart());
        this.linearVelocityOne.changeFrame((ReferenceFrame)this);
        this.linearVelocityTwo.changeFrame((ReferenceFrame)this);
        this.linearVelocity.setToZero((ReferenceFrame)this);
        this.linearVelocity.interpolate((FrameTuple3DReadOnly)this.linearVelocityOne, (FrameTuple3DReadOnly)this.linearVelocityTwo, 0.5);
        twistRelativeToParentToPack.setToZero((ReferenceFrame)this, this.getParent(), (ReferenceFrame)this);
        twistRelativeToParentToPack.getLinearPart().set((FrameTuple3DReadOnly)this.linearVelocity);
        this.linearVelocityOne.sub((FrameTuple3DReadOnly)this.linearVelocity);
        this.linearVelocityTwo.sub((FrameTuple3DReadOnly)this.linearVelocity);
        this.originOne.setToZero((ReferenceFrame)this.frameOne);
        this.originOne.changeFrame((ReferenceFrame)this);
        this.originTwo.setToZero((ReferenceFrame)this.frameTwo);
        this.originTwo.changeFrame((ReferenceFrame)this);
        double distanceFromOne = EuclidCoreTools.norm((double)this.originOne.getX(), (double)this.originOne.getY());
        double distanceFromTwo = EuclidCoreTools.norm((double)this.originTwo.getX(), (double)this.originTwo.getY());
        double omegaZFromOne = this.linearVelocityOne.getX() / distanceFromOne;
        double omegaZFromTwo = this.linearVelocityTwo.getX() / distanceFromTwo;
        twistRelativeToParentToPack.setAngularPartZ(-0.5 * ((omegaZFromOne *= Math.signum(this.originOne.getY())) + (omegaZFromTwo *= Math.signum(this.originTwo.getY()))));
    }
}

