/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import us.ihmc.commons.MathTools;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;

public class Matrix3DEigenValueCalculator {
    private final Matrix3D B = new Matrix3D();
    private double eig1 = Double.NaN;
    private double eig2 = Double.NaN;
    private double eig3 = Double.NaN;

    public void compute(Matrix3DReadOnly matrix) {
        if (!matrix.isMatrixSymmetric()) {
            throw new RuntimeException("Only works for symmetric matrices.");
        }
        double p1 = MathTools.square((double)matrix.getM01()) + MathTools.square((double)matrix.getM02()) + MathTools.square((double)matrix.getM12());
        double q = Matrix3DEigenValueCalculator.trace(matrix) / 3.0;
        double p2 = MathTools.square((double)(matrix.getM00() - q)) + MathTools.square((double)(matrix.getM11() - q)) + MathTools.square((double)(matrix.getM22() - q)) + 2.0 * p1;
        double p = Math.sqrt(p2 / 6.0);
        this.B.set(matrix);
        this.B.subM00(q);
        this.B.subM11(q);
        this.B.subM22(q);
        this.B.scale(1.0 / p);
        double r = this.B.determinant() / 2.0;
        double phi = r <= -1.0 ? 1.0471975511965976 : (r >= 1.0 ? 0.0 : Math.acos(r) / 3.0);
        this.eig1 = q + 2.0 * p * Math.cos(phi);
        this.eig3 = q + 2.0 * p * Math.cos(phi + 2.0943951023931953);
        this.eig2 = 3.0 * q - this.eig1 - this.eig3;
    }

    public double getFirstEigenValue() {
        return this.eig1;
    }

    public double getSecondEigenValue() {
        return this.eig2;
    }

    public double getThirdEigenValue() {
        return this.eig3;
    }

    private static double trace(Matrix3DReadOnly matrix) {
        return matrix.getM00() + matrix.getM11() + matrix.getM22();
    }
}

