/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.screwTheory.ScrewTools;

public class GeometricJacobian {
    private final JointBasics[] joints;
    private final JointBasics[] jointPathFromBaseToEndEffector;
    private final DMatrixRMaj jacobian;
    private ReferenceFrame jacobianFrame;
    private final DMatrixRMaj tempMatrix = new DMatrixRMaj(6, 1);
    private final boolean allowChangeFrame;
    private final int hashCode;
    private final Twist tempTwist = new Twist();

    public GeometricJacobian(JointBasics[] joints, ReferenceFrame jacobianFrame) {
        this(joints, jacobianFrame, true);
    }

    public GeometricJacobian(JointBasics[] joints, ReferenceFrame jacobianFrame, boolean allowChangeFrame) {
        GeometricJacobian.checkJointOrder(joints);
        this.joints = new JointBasics[joints.length];
        System.arraycopy(joints, 0, this.joints, 0, joints.length);
        this.jacobianFrame = jacobianFrame;
        this.jacobian = new DMatrixRMaj(6, MultiBodySystemTools.computeDegreesOfFreedom((JointReadOnly[])joints));
        this.jointPathFromBaseToEndEffector = MultiBodySystemTools.createJointPath((RigidBodyBasics)this.getBase(), (RigidBodyBasics)this.getEndEffector());
        this.allowChangeFrame = allowChangeFrame;
        this.hashCode = ScrewTools.computeGeometricJacobianHashCode(joints, jacobianFrame, allowChangeFrame);
    }

    public GeometricJacobian(JointBasics joint, ReferenceFrame jacobianFrame) {
        this(new JointBasics[]{joint}, jacobianFrame, true);
    }

    public GeometricJacobian(RigidBodyBasics ancestor, RigidBodyBasics descendant, ReferenceFrame jacobianFrame) {
        this(MultiBodySystemTools.createJointPath((RigidBodyBasics)ancestor, (RigidBodyBasics)descendant), jacobianFrame, true);
    }

    public void compute() {
        int column = 0;
        for (int jointIndex = 0; jointIndex < this.joints.length; ++jointIndex) {
            JointBasics joint = this.joints[jointIndex];
            for (int dofIndex = 0; dofIndex < joint.getDegreesOfFreedom(); ++dofIndex) {
                this.tempTwist.setIncludingFrame((SpatialMotionReadOnly)joint.getUnitTwists().get(dofIndex));
                this.tempTwist.changeFrame(this.jacobianFrame);
                this.tempTwist.get(0, column++, (DMatrix)this.jacobian);
            }
        }
    }

    public void changeFrame(ReferenceFrame jacobianFrame) {
        if (!this.allowChangeFrame) {
            throw new RuntimeException("Cannot change the frame of this Jacobian.");
        }
        this.jacobianFrame = jacobianFrame;
    }

    public void getTwist(DMatrixRMaj jointVelocities, Twist twistToPack) {
        CommonOps_DDRM.mult((DMatrix1Row)this.jacobian, (DMatrix1Row)jointVelocities, (DMatrix1Row)this.tempMatrix);
        twistToPack.setIncludingFrame(this.getEndEffectorFrame(), this.getBaseFrame(), this.jacobianFrame, 0, (DMatrix)this.tempMatrix);
    }

    public DMatrixRMaj computeJointTorques(WrenchReadOnly wrench) {
        DMatrixRMaj jointTorques = new DMatrixRMaj(1, this.jacobian.getNumCols());
        this.computeJointTorques(wrench, jointTorques);
        return jointTorques;
    }

    public void computeJointTorques(WrenchReadOnly wrench, DMatrixRMaj jointTorquesToPack) {
        wrench.getReferenceFrame().checkReferenceFrameMatch(this.jacobianFrame);
        wrench.get((DMatrix)this.tempMatrix);
        jointTorquesToPack.reshape(1, this.jacobian.getNumCols());
        CommonOps_DDRM.multTransA((DMatrix1Row)this.tempMatrix, (DMatrix1Row)this.jacobian, (DMatrix1Row)jointTorquesToPack);
        CommonOps_DDRM.transpose((DMatrixRMaj)jointTorquesToPack);
    }

    public DMatrixRMaj getJacobianMatrix() {
        return this.jacobian;
    }

    public double det() {
        return CommonOps_DDRM.det((DMatrixRMaj)this.jacobian);
    }

    public double getJacobianEntry(int row, int column) {
        return this.jacobian.get(row, column);
    }

    public int getNumberOfColumns() {
        return this.jacobian.getNumCols();
    }

    public ReferenceFrame getJacobianFrame() {
        return this.jacobianFrame;
    }

    public JointBasics[] getJointsInOrder() {
        return this.joints;
    }

    public JointBasics[] getJointPathFromBaseToEndEffector() {
        return this.jointPathFromBaseToEndEffector;
    }

    public RigidBodyBasics getBase() {
        return this.joints[0].getPredecessor();
    }

    public RigidBodyBasics getEndEffector() {
        return this.joints[this.joints.length - 1].getSuccessor();
    }

    public ReferenceFrame getBaseFrame() {
        return this.getBase().getBodyFixedFrame();
    }

    public ReferenceFrame getEndEffectorFrame() {
        return this.getEndEffector().getBodyFixedFrame();
    }

    private static void checkJointOrder(JointBasics[] joints) {
        for (int i = 1; i < joints.length; ++i) {
            JointBasics joint = joints[i];
            JointBasics previousJoint = joints[i - 1];
            if (!MultiBodySystemTools.isAncestor((RigidBodyReadOnly)previousJoint.getPredecessor(), (RigidBodyReadOnly)joint.getPredecessor())) continue;
            throw new RuntimeException("joints must be in order from ancestor to descendant");
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Jacobian. jacobianFrame = " + this.jacobianFrame + ". Joints:\n");
        for (JointBasics joint : this.joints) {
            builder.append(joint.getClass().getSimpleName() + " " + joint.getName() + "\n");
        }
        builder.append("\n");
        builder.append(this.jacobian.toString());
        return builder.toString();
    }

    public String getShortInfo() {
        return "Jacobian, end effector = " + this.getEndEffector() + ", base = " + this.getBase() + ", expressed in " + this.getJacobianFrame();
    }

    public int hashCode() {
        return this.hashCode;
    }
}

