/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.algorithms.CentroidalMomentumCalculator;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.robotics.screwTheory.DynamicallyConsistentNullspaceCalculator;
import us.ihmc.robotics.screwTheory.OriginalDynamicallyConsistentNullspaceCalculator;

public class ConstrainedCentroidalMomentumMatrixCalculator {
    private final DynamicallyConsistentNullspaceCalculator dynamicallyConsistentNullspaceCalculator;
    private final CentroidalMomentumCalculator centroidalMomentumCalculator;
    private final DMatrixRMaj selectionMatrix;
    private final DMatrixRMaj temp = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj constrainedCentroidalMomentumMatrix = new DMatrixRMaj(1, 1);

    public ConstrainedCentroidalMomentumMatrixCalculator(FloatingJointBasics rootJoint, ReferenceFrame centerOfMassFrame, DMatrixRMaj selectionMatrix) {
        this.dynamicallyConsistentNullspaceCalculator = new OriginalDynamicallyConsistentNullspaceCalculator(rootJoint, true);
        this.centroidalMomentumCalculator = new CentroidalMomentumCalculator((RigidBodyReadOnly)rootJoint.getSuccessor(), centerOfMassFrame);
        this.selectionMatrix = selectionMatrix;
    }

    public void reset() {
        this.dynamicallyConsistentNullspaceCalculator.reset();
    }

    public void addConstraint(RigidBodyBasics body, DMatrixRMaj selectionMatrix) {
        this.dynamicallyConsistentNullspaceCalculator.addConstraint(body, selectionMatrix);
    }

    public void addActuatedJoint(JointBasics joint) {
        this.dynamicallyConsistentNullspaceCalculator.addActuatedJoint(joint);
    }

    public void compute() {
        this.dynamicallyConsistentNullspaceCalculator.compute();
        this.centroidalMomentumCalculator.reset();
        DMatrixRMaj centroidalMomentumMatrix = this.centroidalMomentumCalculator.getCentroidalMomentumMatrix();
        DMatrixRMaj sNsBar = this.dynamicallyConsistentNullspaceCalculator.getSNsBar();
        this.temp.reshape(centroidalMomentumMatrix.getNumRows(), sNsBar.getNumCols());
        CommonOps_DDRM.mult((DMatrix1Row)centroidalMomentumMatrix, (DMatrix1Row)sNsBar, (DMatrix1Row)this.temp);
        this.constrainedCentroidalMomentumMatrix.reshape(this.selectionMatrix.getNumRows(), this.temp.getNumCols());
        CommonOps_DDRM.mult((DMatrix1Row)this.selectionMatrix, (DMatrix1Row)this.temp, (DMatrix1Row)this.constrainedCentroidalMomentumMatrix);
    }

    public DMatrixRMaj getConstrainedCentroidalMomentumMatrix() {
        return this.constrainedCentroidalMomentumMatrix;
    }

    public DMatrixRMaj getCentroidalMomentumMatrix() {
        return this.centroidalMomentumCalculator.getCentroidalMomentumMatrix();
    }
}

