/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.robotSide;

import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Random;
import org.apache.commons.lang3.ArrayUtils;
import us.ihmc.robotics.robotSide.RobotEnd;
import us.ihmc.robotics.robotSide.RobotSegment;
import us.ihmc.robotics.robotSide.RobotSide;

public enum RobotQuadrant implements RobotSegment<RobotQuadrant>
{
    FRONT_LEFT(RobotEnd.FRONT, RobotSide.LEFT),
    FRONT_RIGHT(RobotEnd.FRONT, RobotSide.RIGHT),
    HIND_RIGHT(RobotEnd.HIND, RobotSide.RIGHT),
    HIND_LEFT(RobotEnd.HIND, RobotSide.LEFT);

    public static final EnumSet<RobotQuadrant> enumSet;
    public static final RobotQuadrant[] values;
    public static final RobotQuadrant[] reversedValues;
    private final RobotEnd end;
    private final RobotSide side;
    public static final int FRONT_LEFT_ORDINAL;
    public static final int FRONT_RIGHT_ORDINAL;
    public static final int HIND_RIGHT_ORDINAL;
    public static final int HIND_LEFT_ORDINAL;
    private static final Color[] colorArray;
    private static final Color[] colorArrayForWhiteBackground;

    private RobotQuadrant(RobotEnd end, RobotSide side) {
        this.end = end;
        this.side = side;
    }

    public static RobotQuadrant generateRandomRobotQuadrant(Random random) {
        if (random.nextBoolean()) {
            if (random.nextBoolean()) {
                return FRONT_LEFT;
            }
            return FRONT_RIGHT;
        }
        if (random.nextBoolean()) {
            return HIND_LEFT;
        }
        return HIND_RIGHT;
    }

    public RobotEnd getEnd() {
        return this.end;
    }

    public RobotEnd getOppositeEnd() {
        return this.end.getOppositeEnd();
    }

    public RobotSide getSide() {
        return this.side;
    }

    public RobotSide getOppositeSide() {
        return this.side.getOppositeSide();
    }

    public static final RobotQuadrant getQuadrant(RobotEnd robotEnd, RobotSide robotSide) {
        if (robotEnd == RobotEnd.HIND) {
            if (robotSide == RobotSide.LEFT) {
                return HIND_LEFT;
            }
            return HIND_RIGHT;
        }
        if (robotSide == RobotSide.LEFT) {
            return FRONT_LEFT;
        }
        return FRONT_RIGHT;
    }

    public final RobotQuadrant getDiagonalOppositeQuadrant() {
        switch (this) {
            case FRONT_LEFT: {
                return HIND_RIGHT;
            }
            case FRONT_RIGHT: {
                return HIND_LEFT;
            }
            case HIND_RIGHT: {
                return FRONT_LEFT;
            }
            case HIND_LEFT: {
                return FRONT_RIGHT;
            }
        }
        throw new RuntimeException();
    }

    public Color getColor() {
        return colorArray[this.ordinal()];
    }

    public Color getColorForWhiteBackground() {
        return colorArrayForWhiteBackground[this.ordinal()];
    }

    public final RobotQuadrant getAcrossBodyQuadrant() {
        switch (this) {
            case FRONT_LEFT: {
                return FRONT_RIGHT;
            }
            case FRONT_RIGHT: {
                return FRONT_LEFT;
            }
            case HIND_RIGHT: {
                return HIND_LEFT;
            }
            case HIND_LEFT: {
                return HIND_RIGHT;
            }
        }
        throw new RuntimeException();
    }

    public final RobotQuadrant getAcrossBodyFrontQuadrant() {
        switch (this) {
            case FRONT_LEFT: {
                return FRONT_RIGHT;
            }
            case FRONT_RIGHT: {
                return FRONT_LEFT;
            }
            case HIND_RIGHT: {
                return FRONT_LEFT;
            }
            case HIND_LEFT: {
                return FRONT_RIGHT;
            }
        }
        throw new RuntimeException();
    }

    public final RobotQuadrant getAcrossBodyHindQuadrant() {
        switch (this) {
            case FRONT_LEFT: {
                return HIND_RIGHT;
            }
            case FRONT_RIGHT: {
                return HIND_LEFT;
            }
            case HIND_RIGHT: {
                return HIND_LEFT;
            }
            case HIND_LEFT: {
                return HIND_RIGHT;
            }
        }
        throw new RuntimeException();
    }

    public final RobotQuadrant getNextClockwiseQuadrant() {
        switch (this) {
            case FRONT_LEFT: {
                return FRONT_RIGHT;
            }
            case FRONT_RIGHT: {
                return HIND_RIGHT;
            }
            case HIND_RIGHT: {
                return HIND_LEFT;
            }
            case HIND_LEFT: {
                return FRONT_LEFT;
            }
        }
        throw new RuntimeException();
    }

    public final RobotQuadrant getNextCounterClockwiseQuadrant() {
        switch (this) {
            case FRONT_LEFT: {
                return HIND_LEFT;
            }
            case HIND_LEFT: {
                return HIND_RIGHT;
            }
            case HIND_RIGHT: {
                return FRONT_RIGHT;
            }
            case FRONT_RIGHT: {
                return FRONT_LEFT;
            }
        }
        throw new RuntimeException();
    }

    public final String getShortName() {
        switch (this) {
            case FRONT_LEFT: {
                return "FL";
            }
            case FRONT_RIGHT: {
                return "FR";
            }
            case HIND_RIGHT: {
                return "HR";
            }
            case HIND_LEFT: {
                return "HL";
            }
        }
        throw new RuntimeException();
    }

    public static ArrayList<RobotQuadrant> getAllQuadrants() {
        ArrayList<RobotQuadrant> quadrantNames = new ArrayList<RobotQuadrant>();
        for (RobotQuadrant quadrantName : RobotQuadrant.values()) {
            quadrantNames.add(quadrantName);
        }
        return quadrantNames;
    }

    public static ArrayList<RobotQuadrant> getFrontQuadrants() {
        ArrayList<RobotQuadrant> quadrantNames = new ArrayList<RobotQuadrant>();
        for (RobotQuadrant quadrantName : RobotQuadrant.values()) {
            if (!quadrantName.isQuadrantInFront()) continue;
            quadrantNames.add(quadrantName);
        }
        return quadrantNames;
    }

    public static ArrayList<RobotQuadrant> getHindQuadrants() {
        ArrayList<RobotQuadrant> quadrantNames = new ArrayList<RobotQuadrant>();
        for (RobotQuadrant quadrantName : RobotQuadrant.values()) {
            if (!quadrantName.isQuadrantInHind()) continue;
            quadrantNames.add(quadrantName);
        }
        return quadrantNames;
    }

    public static ArrayList<RobotQuadrant> getDiagonalOppositeQuadrants(boolean useFrontLeft) {
        ArrayList<RobotQuadrant> quadrantNames = new ArrayList<RobotQuadrant>();
        if (useFrontLeft) {
            quadrantNames.add(FRONT_LEFT);
            quadrantNames.add(HIND_RIGHT);
        } else {
            quadrantNames.add(FRONT_RIGHT);
            quadrantNames.add(HIND_LEFT);
        }
        return quadrantNames;
    }

    public final RobotQuadrant getSameSideQuadrant() {
        switch (this) {
            case FRONT_LEFT: {
                return HIND_LEFT;
            }
            case FRONT_RIGHT: {
                return HIND_RIGHT;
            }
            case HIND_RIGHT: {
                return FRONT_RIGHT;
            }
            case HIND_LEFT: {
                return FRONT_LEFT;
            }
        }
        throw new RuntimeException();
    }

    public final boolean isQuadrantOnLeftSide() {
        return this == FRONT_LEFT || this == HIND_LEFT;
    }

    public final boolean isQuadrantOnRightSide() {
        return this == FRONT_RIGHT || this == HIND_RIGHT;
    }

    public final boolean isQuadrantInFront() {
        return this == FRONT_LEFT || this == FRONT_RIGHT;
    }

    public final boolean isQuadrantInHind() {
        return this == HIND_LEFT || this == HIND_RIGHT;
    }

    public final RobotQuadrant getNextRegularGaitSwingQuadrant() {
        return RobotQuadrant.getNextRegularGaitSwingQuadrant(this);
    }

    public final RobotQuadrant getNextReversedRegularGaitSwingQuadrant() {
        return RobotQuadrant.getNextReversedRegularGaitSwingQuadrant(this);
    }

    public static final RobotQuadrant getNextRegularGaitSwingQuadrant(RobotQuadrant currentSwingQuadrant) {
        switch (currentSwingQuadrant) {
            case FRONT_LEFT: {
                return HIND_RIGHT;
            }
            case FRONT_RIGHT: {
                return HIND_LEFT;
            }
            case HIND_RIGHT: {
                return FRONT_RIGHT;
            }
            case HIND_LEFT: {
                return FRONT_LEFT;
            }
        }
        throw new RuntimeException();
    }

    public static final RobotQuadrant getNextReversedRegularGaitSwingQuadrant(RobotQuadrant currentSwingQuadrant) {
        switch (currentSwingQuadrant) {
            case FRONT_LEFT: {
                return HIND_LEFT;
            }
            case FRONT_RIGHT: {
                return HIND_RIGHT;
            }
            case HIND_RIGHT: {
                return FRONT_LEFT;
            }
            case HIND_LEFT: {
                return FRONT_RIGHT;
            }
        }
        throw new RuntimeException();
    }

    public static RobotQuadrant getQuadrantNameFromOrdinal(int quadrantIndex) {
        return values[quadrantIndex];
    }

    public static RobotQuadrant getQuadrantName(String quadrantName) {
        if (quadrantName.equals(FRONT_LEFT.toString())) {
            return FRONT_LEFT;
        }
        if (quadrantName.equals(FRONT_RIGHT.toString())) {
            return FRONT_RIGHT;
        }
        if (quadrantName.equals(HIND_LEFT.toString())) {
            return HIND_LEFT;
        }
        if (quadrantName.equals(HIND_RIGHT.toString())) {
            return HIND_RIGHT;
        }
        throw new RuntimeException("Invalid quadrant name: " + quadrantName);
    }

    public static RobotQuadrant guessQuadrantFromName(String name) {
        if (name.contains("front") || name.contains("Front")) {
            if (name.contains("left") || name.contains("Left")) {
                return FRONT_LEFT;
            }
            if (name.contains("right") || name.contains("Right")) {
                return FRONT_RIGHT;
            }
        } else if (name.contains("hind") || name.contains("Hind")) {
            if (name.contains("left") || name.contains("Left")) {
                return HIND_LEFT;
            }
            if (name.contains("right") || name.contains("Right")) {
                return HIND_RIGHT;
            }
        } else if (name.contains("hip") || name.contains("Hip") || name.contains("HIP") || name.contains("knee") || name.contains("Knee") || name.contains("KNEE")) {
            if (name.contains("left") || name.contains("Left") || name.contains("LEFT")) {
                return HIND_LEFT;
            }
            if (name.contains("right") || name.contains("Right") || name.contains("RIGHT")) {
                return HIND_RIGHT;
            }
        } else if (name.contains("shoulder") || name.contains("Shoulder") || name.contains("SHOULDER") || name.contains("elbow") || name.contains("Elbow") || name.contains("ELBOW")) {
            if (name.contains("left") || name.contains("Left") || name.contains("LEFT")) {
                return FRONT_LEFT;
            }
            if (name.contains("right") || name.contains("Right") || name.contains("RIGHT")) {
                return FRONT_RIGHT;
            }
        }
        return null;
    }

    public String getPascalCaseName() {
        switch (this) {
            case FRONT_LEFT: {
                return "FrontLeft";
            }
            case FRONT_RIGHT: {
                return "FrontRight";
            }
            case HIND_RIGHT: {
                return "HindRight";
            }
            case HIND_LEFT: {
                return "HindLeft";
            }
        }
        throw new RuntimeException();
    }

    public String getTitleCaseName() {
        switch (this) {
            case FRONT_LEFT: {
                return "Front Left";
            }
            case FRONT_RIGHT: {
                return "Front Right";
            }
            case HIND_RIGHT: {
                return "Hind Right";
            }
            case HIND_LEFT: {
                return "Hind Left";
            }
        }
        throw new RuntimeException();
    }

    public String getCamelCaseName() {
        switch (this) {
            case FRONT_LEFT: {
                return "frontLeft";
            }
            case FRONT_RIGHT: {
                return "frontRight";
            }
            case HIND_RIGHT: {
                return "hindRight";
            }
            case HIND_LEFT: {
                return "hindLeft";
            }
        }
        throw new RuntimeException();
    }

    public String getUnderBarName() {
        switch (this) {
            case FRONT_LEFT: {
                return "front_left";
            }
            case FRONT_RIGHT: {
                return "front_right";
            }
            case HIND_RIGHT: {
                return "hind_right";
            }
            case HIND_LEFT: {
                return "hind_left";
            }
        }
        throw new RuntimeException();
    }

    public String getCamelCaseNameForMiddleOfExpression() {
        return this.getPascalCaseName();
    }

    @Override
    public String getCamelCaseNameForStartOfExpression() {
        return this.getCamelCaseName();
    }

    public byte toByte() {
        return (byte)this.ordinal();
    }

    public static RobotQuadrant fromByte(byte enumAsByte) {
        if (enumAsByte == -1) {
            return null;
        }
        return values[enumAsByte];
    }

    @Override
    public EnumSet<RobotQuadrant> getEnumSet() {
        return enumSet;
    }

    public RobotQuadrant[] getValues() {
        return values;
    }

    @Override
    public Class<RobotQuadrant> getClassType() {
        return RobotQuadrant.class;
    }

    static {
        enumSet = EnumSet.allOf(RobotQuadrant.class);
        values = RobotQuadrant.values();
        reversedValues = RobotQuadrant.values();
        ArrayUtils.reverse((Object[])reversedValues);
        FRONT_LEFT_ORDINAL = FRONT_LEFT.ordinal();
        FRONT_RIGHT_ORDINAL = FRONT_RIGHT.ordinal();
        HIND_RIGHT_ORDINAL = HIND_RIGHT.ordinal();
        HIND_LEFT_ORDINAL = HIND_LEFT.ordinal();
        colorArray = new Color[]{Color.YELLOW, Color.WHITE, Color.BLUE, Color.BLACK};
        colorArrayForWhiteBackground = new Color[]{Color.YELLOW, Color.PINK, Color.BLUE, Color.BLACK};
    }
}

