/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.robotSide;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import us.ihmc.robotics.robotSide.RobotQuadrant;
import us.ihmc.robotics.robotSide.SegmentDependentList;

public class QuadrantDependentList<V>
extends SegmentDependentList<RobotQuadrant, V> {
    private final RobotQuadrant[][] quadrantArrays = new RobotQuadrant[5][];

    public QuadrantDependentList() {
        super(RobotQuadrant.class);
        this.quadrantArrays[0] = new RobotQuadrant[0];
        this.quadrantArrays[1] = new RobotQuadrant[1];
        this.quadrantArrays[2] = new RobotQuadrant[2];
        this.quadrantArrays[3] = new RobotQuadrant[3];
        this.quadrantArrays[4] = RobotQuadrant.values;
    }

    public QuadrantDependentList(Supplier<V> allocator) {
        this(allocator.get(), allocator.get(), allocator.get(), allocator.get());
    }

    public QuadrantDependentList(V frontLeftObject, V frontRightObject, V hindLeftObject, V hindRightObject) {
        super(RobotQuadrant.class);
        this.quadrantArrays[0] = new RobotQuadrant[0];
        this.quadrantArrays[1] = new RobotQuadrant[1];
        this.quadrantArrays[2] = new RobotQuadrant[2];
        this.quadrantArrays[3] = new RobotQuadrant[3];
        this.quadrantArrays[4] = RobotQuadrant.values;
        this.set(RobotQuadrant.FRONT_LEFT, frontLeftObject);
        this.set(RobotQuadrant.FRONT_RIGHT, frontRightObject);
        this.set(RobotQuadrant.HIND_RIGHT, hindRightObject);
        this.set(RobotQuadrant.HIND_LEFT, hindLeftObject);
    }

    public QuadrantDependentList(SegmentDependentList<RobotQuadrant, ? extends V> other) {
        super(RobotQuadrant.class);
        this.quadrantArrays[0] = new RobotQuadrant[0];
        this.quadrantArrays[1] = new RobotQuadrant[1];
        this.quadrantArrays[2] = new RobotQuadrant[2];
        this.quadrantArrays[3] = new RobotQuadrant[3];
        this.quadrantArrays[4] = RobotQuadrant.values;
        for (RobotQuadrant robotQuadrant : RobotQuadrant.values) {
            this.set(robotQuadrant, other.get(robotQuadrant));
        }
    }

    public RobotQuadrant[] quadrants() {
        this.fillQuadrantArray();
        return this.quadrantArrays[this.size()];
    }

    private void fillQuadrantArray() {
        if (this.size() == 4) {
            return;
        }
        int j = 0;
        for (int i = 0; i < RobotQuadrant.values.length; ++i) {
            if (!this.containsKey(RobotQuadrant.values[i])) continue;
            this.quadrantArrays[this.size()][j++] = RobotQuadrant.values[i];
        }
    }

    public static <K extends Enum<K>, V> QuadrantDependentList<EnumMap<K, V>> createListOfEnumMaps(Class<K> keyType) {
        return new QuadrantDependentList(new EnumMap(keyType), new EnumMap(keyType), new EnumMap(keyType), new EnumMap(keyType));
    }

    public static <K, V> QuadrantDependentList<Map<K, V>> createListOfHashMaps() {
        return new QuadrantDependentList<Map<K, V>>(new LinkedHashMap(), new LinkedHashMap(), new LinkedHashMap(), new LinkedHashMap());
    }

    public static <V> QuadrantDependentList<ArrayList<V>> createListOfArrayLists() {
        return new QuadrantDependentList<ArrayList<V>>(new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList());
    }

    public static <V> QuadrantDependentList<V> build(Function<RobotQuadrant, V> values) {
        QuadrantDependentList<V> quadrantDependentList = new QuadrantDependentList<V>();
        for (RobotQuadrant quadrant : RobotQuadrant.values) {
            quadrantDependentList.put(quadrant, values.apply(quadrant));
        }
        return quadrantDependentList;
    }
}

