/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.referenceFrames;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;

public class ZUpFrame
extends ReferenceFrame {
    private final ReferenceFrame rootFrame;
    private final ReferenceFrame nonZUpFrame;

    @Deprecated
    public ZUpFrame(ReferenceFrame worldFrame, ReferenceFrame nonZUpFrame, String name) {
        this(nonZUpFrame, name);
    }

    public ZUpFrame(ReferenceFrame nonZUpFrame, String name) {
        super(name, nonZUpFrame.getRootFrame(), false, true);
        this.rootFrame = nonZUpFrame.getRootFrame();
        this.nonZUpFrame = nonZUpFrame;
    }

    protected void updateTransformToParent(RigidBodyTransform transformToParent) {
        this.nonZUpFrame.getTransformToDesiredFrame(transformToParent, this.rootFrame);
        double sinPitch = -transformToParent.getM20();
        double cosPitch = Math.sqrt(1.0 - sinPitch * sinPitch);
        if (EuclidCoreTools.isZero((double)cosPitch, (double)1.0E-12)) {
            transformToParent.getRotation().setIdentity();
        } else {
            double cosYaw = transformToParent.getM00() / cosPitch;
            double sinYaw = transformToParent.getM10() / cosPitch;
            double invNorm = 1.0 / EuclidCoreTools.norm((double)cosYaw, (double)sinYaw);
            transformToParent.getRotation().setUnsafe(cosYaw *= invNorm, -(sinYaw *= invNorm), 0.0, sinYaw, cosYaw, 0.0, 0.0, 0.0, 1.0);
        }
    }
}

