/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.referenceFrames;

import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class PointXAxisAtPositionFrame
extends ReferenceFrame {
    private final FramePoint3D positionToPointAt;
    private final Vector3D xAxis = new Vector3D();
    private final Vector3D yAxis = new Vector3D();
    private final Vector3D zAxis = new Vector3D(0.0, 0.0, 1.0);
    private final RotationMatrix rotationMatrix = new RotationMatrix();

    public PointXAxisAtPositionFrame(String name, ReferenceFrame originFrame) {
        super(name, originFrame);
        this.positionToPointAt = new FramePoint3D(originFrame);
    }

    public void setPositionToPointAt(FramePoint3D positionToPointAt) {
        positionToPointAt.changeFrame(this.getParent());
        this.positionToPointAt.set(positionToPointAt);
    }

    protected void updateTransformToParent(RigidBodyTransform transformToParent) {
        this.xAxis.set((Tuple3DReadOnly)this.positionToPointAt);
        this.xAxis.setZ(0.0);
        this.xAxis.normalize();
        this.yAxis.cross((Tuple3DReadOnly)this.zAxis, (Tuple3DReadOnly)this.xAxis);
        this.rotationMatrix.setColumns((Tuple3DReadOnly)this.xAxis, (Tuple3DReadOnly)this.yAxis, (Tuple3DReadOnly)this.zAxis);
        transformToParent.getRotation().set((RotationMatrixReadOnly)this.rotationMatrix);
    }
}

