/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.referenceFrames;

import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class MidFrameZUpFrame
extends ReferenceFrame {
    private final ReferenceFrame parentZUpFrame;
    private final ReferenceFrame frameOne;
    private final ReferenceFrame frameTwo;
    private final FramePoint3D originOneInParent;
    private final FramePoint3D originTwoInParent;
    private final FrameVector3D vectorBetweenFrames;
    private final Vector2D vectorBetweenFrames2d = new Vector2D();
    private final Vector3D parentToMidpointVector3d = new Vector3D();
    private final RigidBodyTransform transform3D = new RigidBodyTransform();

    public MidFrameZUpFrame(String name, ReferenceFrame parentZUpFrame, ReferenceFrame frameOne, ReferenceFrame frameTwo) {
        super(name, parentZUpFrame, false, true);
        if (!parentZUpFrame.isZupFrame()) {
            throw new RuntimeException("!parentZUpFrame.isZupFrame()");
        }
        this.parentZUpFrame = parentZUpFrame;
        this.frameOne = frameOne;
        this.frameTwo = frameTwo;
        this.originOneInParent = new FramePoint3D(frameOne);
        this.originTwoInParent = new FramePoint3D(frameTwo);
        this.vectorBetweenFrames = new FrameVector3D(parentZUpFrame);
    }

    protected void updateTransformToParent(RigidBodyTransform transformToParent) {
        this.originOneInParent.setToZero(this.frameOne);
        this.originOneInParent.changeFrame(this.parentZUpFrame);
        this.originTwoInParent.setToZero(this.frameTwo);
        this.originTwoInParent.changeFrame(this.parentZUpFrame);
        this.vectorBetweenFrames.sub((FrameTuple3DReadOnly)this.originTwoInParent, (FrameTuple3DReadOnly)this.originOneInParent);
        this.vectorBetweenFrames2d.set(this.vectorBetweenFrames.getX(), this.vectorBetweenFrames.getY());
        this.parentToMidpointVector3d.add((Tuple3DReadOnly)this.originOneInParent, (Tuple3DReadOnly)this.originTwoInParent);
        this.parentToMidpointVector3d.scale(0.5);
        this.transform3D.setIdentity();
        if (this.vectorBetweenFrames2d.lengthSquared() < 1.0E-7) {
            return;
        }
        this.vectorBetweenFrames2d.normalize();
        this.transform3D.setRotationYawAndZeroTranslation(1.5707963267948966 + Math.atan2(this.vectorBetweenFrames2d.getY(), this.vectorBetweenFrames2d.getX()));
        this.transform3D.getTranslation().set((Tuple3DReadOnly)this.parentToMidpointVector3d);
        transformToParent.set(this.transform3D);
    }
}

