/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.quadTree;

import java.util.ArrayList;
import java.util.Collection;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.quadTree.Box;
import us.ihmc.robotics.quadTree.PointAndDistance;
import us.ihmc.robotics.quadTree.QuadTreeForGroundNode;
import us.ihmc.robotics.quadTree.QuadTreeForGroundPoint;
import us.ihmc.robotics.quadTree.QuadTreeForGroundPointLimiter;

public class QuadTreeForGroundLeaf {
    private final ArrayList<QuadTreeForGroundPoint> points = new ArrayList();
    private Point3D averagePoint = null;
    private final QuadTreeForGroundNode node;
    private final QuadTreeForGroundPointLimiter pointLimiter;

    public QuadTreeForGroundLeaf(QuadTreeForGroundNode node, QuadTreeForGroundPointLimiter pointLimiter) {
        this.node = node;
        this.pointLimiter = pointLimiter;
    }

    public Point3D getAveragePoint() {
        if (this.averagePoint == null) {
            this.averagePoint = new Point3D(Double.NaN, Double.NaN, Double.NaN);
        }
        if (Double.isNaN(this.averagePoint.getX())) {
            this.averagePoint.set(0.0, 0.0, 0.0);
            int numberOfPoints = this.points.size();
            for (int i = 0; i < numberOfPoints; ++i) {
                this.averagePoint.add((Tuple3DReadOnly)this.points.get(i));
            }
            this.averagePoint.scale(1.0 / (double)numberOfPoints);
        }
        return this.averagePoint;
    }

    public void clear() {
        if (this.pointLimiter != null) {
            for (int i = 0; i < this.points.size(); ++i) {
                this.pointLimiter.remove((Object)this.points.get(i));
            }
        }
        this.points.clear();
        this.setAveragePointDirty();
    }

    public ArrayList<QuadTreeForGroundPoint> getPoints() {
        return this.points;
    }

    public int getNumberOfPoints() {
        return this.points.size();
    }

    public void addPoint(QuadTreeForGroundPoint point) {
        this.points.add(point);
        point.setParent(this);
        if (this.pointLimiter != null) {
            this.pointLimiter.add(point);
        }
        this.setAveragePointDirty();
    }

    public void replaceLeastRecentPoint(QuadTreeForGroundPoint point) {
        this.setAveragePointDirty();
        QuadTreeForGroundPoint removed = this.points.remove(0);
        this.points.add(point);
        point.setParent(this);
        if (this.pointLimiter != null) {
            if (removed != null) {
                this.pointLimiter.remove((Object)removed);
            }
            this.pointLimiter.add(point);
        }
    }

    private void setAveragePointDirty() {
        if (this.averagePoint != null) {
            this.averagePoint.set(Double.NaN, Double.NaN, Double.NaN);
        }
    }

    public void getClosestPointAndDistanceUsingAverage(double x, double y, PointAndDistance closestPointAndDistance) {
        double bestDistanceSquared;
        Point3D averagePoint = this.getAveragePoint();
        double distanceSquared = this.distanceXYSquared(x, y, averagePoint);
        if (distanceSquared < (bestDistanceSquared = closestPointAndDistance.getDistance() * closestPointAndDistance.getDistance())) {
            closestPointAndDistance.setPoint(averagePoint);
            closestPointAndDistance.setDistance(Math.sqrt(distanceSquared));
        }
    }

    public void getClosestPointAndDistanceUsingAverageHeight(double x, double y, PointAndDistance closestPointAndDistance) {
        double bestDistanceSquared = closestPointAndDistance.getDistance() * closestPointAndDistance.getDistance();
        Point3D betterPoint = null;
        for (Point3D point3D : this.points) {
            double distanceSquared = this.distanceXYSquared(x, y, point3D);
            if (!(distanceSquared < bestDistanceSquared)) continue;
            betterPoint = point3D;
            bestDistanceSquared = distanceSquared;
        }
        if (betterPoint != null) {
            Point3D averagePoint = this.getAveragePoint();
            closestPointAndDistance.setPoint(betterPoint);
            closestPointAndDistance.setPointZ(averagePoint.getZ());
            closestPointAndDistance.setDistance(Math.sqrt(bestDistanceSquared));
        }
    }

    private double distanceXYSquared(double x, double y, Point3D point) {
        if (point == null) {
            return Double.POSITIVE_INFINITY;
        }
        return (x - point.getX()) * (x - point.getX()) + (y - point.getY()) * (y - point.getY());
    }

    public void getAllPoints(Collection<Point3D> pointsToPack) {
        pointsToPack.addAll(this.points);
    }

    public void getAllPointsWithinBounds(Box bounds, ArrayList<Point3D> pointsToPack) {
        for (Point3D point3D : this.points) {
            if (!bounds.containsOrEquals(point3D.getX(), point3D.getY())) continue;
            pointsToPack.add(point3D);
        }
    }

    public void getAllPointsWithinDistance(double x, double y, double maxDistance, ArrayList<Point3D> pointsWithinDistanceToPack) {
        if (maxDistance < 0.0) {
            return;
        }
        double maxDistanceSquared = maxDistance * maxDistance;
        for (Point3D point3D : this.points) {
            double distanceSquared = (point3D.getX() - x) * (point3D.getX() - x) + (point3D.getY() - y) * (point3D.getY() - y);
            if (!(distanceSquared < maxDistanceSquared)) continue;
            pointsWithinDistanceToPack.add(point3D);
        }
    }

    public void checkRepInvarients(Box bounds) {
        if (this.points == null || this.points.isEmpty()) {
            throw new RuntimeException("All leaves should have at least one point");
        }
        if (this.points != null && !this.points.isEmpty()) {
            for (Point3D point3D : this.points) {
                if (bounds.containsOrEquals(point3D.getX(), point3D.getY())) continue;
                throw new RuntimeException();
            }
        }
        if (this.averagePoint != null && Double.isNaN(this.averagePoint.getX())) {
            Point3D averageCheck = new Point3D((Tuple3DReadOnly)this.averagePoint);
            this.averagePoint.set(Double.NaN, Double.NaN, Double.NaN);
            if (averageCheck.distance((Point3DReadOnly)this.getAveragePoint()) > 1.0E-7) {
                throw new RuntimeException();
            }
        }
    }

    public String toString() {
        return "QuadLeaf. Number of points = " + this.points.size() + ". " + this.points.toString();
    }

    public void removePoint(QuadTreeForGroundPoint quadTreeForGroundPoint) {
        this.points.remove((Object)quadTreeForGroundPoint);
        if (this.points.size() == 0) {
            this.node.merge();
        }
    }
}

