/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.physics;

import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.algorithms.ForwardDynamicsCalculator;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.physics.ExternalWrenchProvider;
import us.ihmc.robotics.physics.MultiBodySystemStateWriter;

public class SingleRobotForwardDynamicsPlugin {
    private final MultiBodySystemBasics input;
    private final ForwardDynamicsCalculator forwardDynamicsCalculator;
    private MultiBodySystemStateWriter controllerOutputWriter;
    private final DMatrixRMaj jointVelocityMatrix;

    public SingleRobotForwardDynamicsPlugin(MultiBodySystemBasics input) {
        this.input = input;
        this.forwardDynamicsCalculator = new ForwardDynamicsCalculator((MultiBodySystemReadOnly)input);
        this.jointVelocityMatrix = new DMatrixRMaj(MultiBodySystemTools.computeDegreesOfFreedom((List)input.getJointsToConsider()), 1);
    }

    public void setControllerOutputWriter(MultiBodySystemStateWriter controllerOutputWriter) {
        this.controllerOutputWriter = controllerOutputWriter;
    }

    public void doScience(double time, double dt, Vector3DReadOnly gravity) {
        this.forwardDynamicsCalculator.setGravitionalAcceleration((Tuple3DReadOnly)gravity);
        this.forwardDynamicsCalculator.compute();
    }

    public void readJointVelocities() {
        MultiBodySystemTools.extractJointsState((List)this.input.getJointsToConsider(), (JointStateType)JointStateType.VELOCITY, (DMatrix)this.jointVelocityMatrix);
    }

    public void addJointVelocities(DMatrixRMaj jointVelocityToAdd) {
        if (jointVelocityToAdd != null) {
            CommonOps_DDRM.addEquals((DMatrixD1)this.jointVelocityMatrix, (DMatrixD1)jointVelocityToAdd);
        }
    }

    public void writeJointVelocities() {
        MultiBodySystemTools.insertJointsState((List)this.input.getJointsToConsider(), (JointStateType)JointStateType.VELOCITY, (DMatrix)this.jointVelocityMatrix);
    }

    public void writeJointAccelerations() {
        MultiBodySystemTools.insertJointsState((List)this.input.getJointsToConsider(), (JointStateType)JointStateType.ACCELERATION, (DMatrix)this.forwardDynamicsCalculator.getJointAccelerationMatrix());
    }

    public void applyControllerOutput() {
        if (this.controllerOutputWriter != null) {
            this.controllerOutputWriter.write();
        }
    }

    public void resetExternalWrenches() {
        this.forwardDynamicsCalculator.setExternalWrenchesToZero();
    }

    public void applyExternalWrenches(List<ExternalWrenchProvider> externalWrenchProviders) {
        RigidBodyReadOnly rootBody = this.forwardDynamicsCalculator.getInput().getRootBody();
        for (int i = 0; i < externalWrenchProviders.size(); ++i) {
            externalWrenchProviders.get(i).applyExternalWrenches(rootBody, arg_0 -> ((ForwardDynamicsCalculator)this.forwardDynamicsCalculator).getExternalWrench(arg_0));
        }
    }

    public ForwardDynamicsCalculator getForwardDynamicsCalculator() {
        return this.forwardDynamicsCalculator;
    }
}

