/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.physics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyTwistProvider;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class ImpulseBasedRigidBodyTwistProvider
implements RigidBodyTwistProvider {
    private final ReferenceFrame inertialFrame;
    private final RigidBodyBasics rootBody;
    private int impulseDimension;
    private final Twist twist = new Twist();
    private final FrameVector3D linearVelocity = new FrameVector3D();
    private boolean isImpulseZero = true;
    private final DMatrixRMaj impulse = new DMatrixRMaj(6, 1);
    private final List<RigidBodyBasics> rigidBodies = new ArrayList<RigidBodyBasics>();
    private final Map<RigidBodyBasics, DMatrixRMaj> apparentInertiaMatrixInverseMap = new HashMap<RigidBodyBasics, DMatrixRMaj>();
    private final DMatrixRMaj twistMatrix = new DMatrixRMaj(6, 1);

    public ImpulseBasedRigidBodyTwistProvider(ReferenceFrame inertialFrame, RigidBodyBasics rootBody) {
        this.inertialFrame = inertialFrame;
        this.rootBody = rootBody;
    }

    public void clear(int impulseDimension) {
        this.isImpulseZero = true;
        this.impulseDimension = impulseDimension;
        this.impulse.reshape(impulseDimension, 1);
        this.impulse.zero();
        this.rigidBodies.clear();
        this.apparentInertiaMatrixInverseMap.clear();
    }

    public void addAll(Collection<? extends RigidBodyBasics> bodies) {
        for (RigidBodyBasics rigidBodyBasics : bodies) {
            this.add(rigidBodyBasics);
        }
    }

    public void add(RigidBodyBasics rigidBody) {
        if (MultiBodySystemTools.getRootBody((RigidBodyBasics)rigidBody) != this.rootBody) {
            return;
        }
        this.rigidBodies.add(rigidBody);
        this.apparentInertiaMatrixInverseMap.put(rigidBody, new DMatrixRMaj(6, this.impulseDimension));
    }

    public List<RigidBodyBasics> getRigidBodies() {
        return this.rigidBodies;
    }

    public DMatrixRMaj getApparentInertiaMatrixInverse(RigidBodyBasics rigidBody) {
        return this.apparentInertiaMatrixInverseMap.get(rigidBody);
    }

    public void setImpulseToZero() {
        this.isImpulseZero = true;
        this.impulse.zero();
    }

    public void setImpulse(double impulse) {
        this.isImpulseZero = false;
        this.impulse.set(0, impulse);
    }

    public void setImpulse(DMatrixRMaj impulse) {
        this.isImpulseZero = false;
        this.impulse.set((DMatrixD1)impulse);
    }

    public void setImpulse(Vector3DReadOnly impulse) {
        this.isImpulseZero = false;
        impulse.get((DMatrix)this.impulse);
    }

    public void setImpulse(Vector3DReadOnly impulseLinear, double impulseAngular) {
        this.isImpulseZero = false;
        impulseLinear.get((DMatrix)this.impulse);
        this.impulse.set(3, 0, impulseAngular);
    }

    public TwistReadOnly getTwistOfBody(RigidBodyReadOnly body) {
        if (this.isImpulseZero) {
            return null;
        }
        DMatrixRMaj apparentInertiaMatrixInverse = this.apparentInertiaMatrixInverseMap.get(body);
        if (apparentInertiaMatrixInverse == null) {
            return null;
        }
        CommonOps_DDRM.mult((DMatrix1Row)apparentInertiaMatrixInverse, (DMatrix1Row)this.impulse, (DMatrix1Row)this.twistMatrix);
        this.twist.setIncludingFrame((ReferenceFrame)body.getBodyFixedFrame(), this.inertialFrame, (ReferenceFrame)body.getBodyFixedFrame(), (DMatrix)this.twistMatrix);
        return this.twist;
    }

    public TwistReadOnly getRelativeTwist(RigidBodyReadOnly base, RigidBodyReadOnly body) {
        throw new UnsupportedOperationException("Relative twist is not supported.");
    }

    public FrameVector3DReadOnly getLinearVelocityOfBodyFixedPoint(RigidBodyReadOnly base, RigidBodyReadOnly body, FramePoint3DReadOnly bodyFixedPoint) {
        if (this.isImpulseZero) {
            return null;
        }
        if (base != null) {
            this.getRelativeTwist(base, body).getLinearVelocityAt(bodyFixedPoint, (FrameVector3DBasics)this.linearVelocity);
        } else {
            this.getTwistOfBody(body).getLinearVelocityAt(bodyFixedPoint, (FrameVector3DBasics)this.linearVelocity);
        }
        return this.linearVelocity;
    }

    public ReferenceFrame getInertialFrame() {
        return this.inertialFrame;
    }
}

