/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.physics;

import us.ihmc.robotics.physics.ContactParametersBasics;

public class ContactParameters
implements ContactParametersBasics {
    private double minimumPenetration;
    private double coefficientOfFriction;
    private double coefficientOfRestitution;
    private double restitutionThreshold;
    private double errorReductionParameter;
    private boolean computeMomentFriction;
    private double coulombMomentFrictionRatio;

    public static ContactParameters defaultIneslasticContactParameters(boolean computeMomentFriction) {
        ContactParameters contactParameters = new ContactParameters();
        contactParameters.setMinimumPenetration(5.0E-5);
        contactParameters.setCoefficientOfFriction(0.7);
        contactParameters.setCoefficientOfRestitution(0.0);
        contactParameters.setRestitutionThreshold(0.0);
        contactParameters.setErrorReductionParameter(0.0);
        contactParameters.setComputeFrictionMoment(computeMomentFriction);
        contactParameters.setCoulombMomentFrictionRatio(0.3);
        return contactParameters;
    }

    public ContactParameters() {
    }

    public ContactParameters(double minimumPenetration, double coefficientOfFriction, double coefficientOfRestitution, double restitutionThreshold, double errorReductionParameter, boolean computeMomentFriction, double coulombMomentFrictionRatio) {
        this.minimumPenetration = minimumPenetration;
        this.coefficientOfFriction = coefficientOfFriction;
        this.coefficientOfRestitution = coefficientOfRestitution;
        this.restitutionThreshold = restitutionThreshold;
        this.errorReductionParameter = errorReductionParameter;
        this.computeMomentFriction = computeMomentFriction;
        this.coulombMomentFrictionRatio = coulombMomentFrictionRatio;
    }

    @Override
    public void setMinimumPenetration(double minimumPenetration) {
        this.minimumPenetration = minimumPenetration;
    }

    @Override
    public void setCoefficientOfFriction(double coefficientOfFriction) {
        this.coefficientOfFriction = coefficientOfFriction;
    }

    @Override
    public void setCoefficientOfRestitution(double coefficientOfRestitution) {
        this.coefficientOfRestitution = coefficientOfRestitution;
    }

    @Override
    public void setRestitutionThreshold(double restitutionThreshold) {
        this.restitutionThreshold = restitutionThreshold;
    }

    @Override
    public void setErrorReductionParameter(double errorReductionParameter) {
        this.errorReductionParameter = errorReductionParameter;
    }

    @Override
    public void setComputeFrictionMoment(boolean computeFrictionMoment) {
        this.computeMomentFriction = computeFrictionMoment;
    }

    @Override
    public void setCoulombMomentFrictionRatio(double coulombFrictionMomentRatio) {
        this.coulombMomentFrictionRatio = coulombFrictionMomentRatio;
    }

    @Override
    public double getMinimumPenetration() {
        return this.minimumPenetration;
    }

    @Override
    public double getCoefficientOfFriction() {
        return this.coefficientOfFriction;
    }

    @Override
    public double getCoefficientOfRestitution() {
        return this.coefficientOfRestitution;
    }

    @Override
    public double getRestitutionThreshold() {
        return this.restitutionThreshold;
    }

    @Override
    public double getErrorReductionParameter() {
        return this.errorReductionParameter;
    }

    @Override
    public boolean getComputeFrictionMoment() {
        return this.computeMomentFriction;
    }

    @Override
    public double getCoulombMomentFrictionRatio() {
        return this.coulombMomentFrictionRatio;
    }
}

