/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.physics;

import java.util.Random;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.RandomMatrices_DDRM;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.robotics.physics.ContactImpulseTools;

public class ContactImpulseRandomTools {
    public static DMatrixRMaj nextSquareFullRank(Random random) {
        return ContactImpulseRandomTools.nextSquareFullRank(random, 0.001, 10.0);
    }

    public static DMatrixRMaj nextSquareFullRank(Random random, double singularValueMin, double singularValueMax) {
        return ContactImpulseRandomTools.nextSquareFullRank(random, singularValueMin, singularValueMax, 0.25);
    }

    public static DMatrixRMaj nextSquareFullRank(Random random, double singularValueMin, double singularValueMax, double probabilityNegativeSingularValue) {
        double[] singularValues = new double[3];
        for (int j = 0; j < 3; ++j) {
            singularValues[j] = EuclidCoreRandomTools.nextDouble((Random)random, (double)singularValueMin, (double)singularValueMax);
            if (!(random.nextDouble() < probabilityNegativeSingularValue)) continue;
            singularValues[j] = -singularValues[j];
        }
        DMatrixRMaj M_inv = RandomMatrices_DDRM.singular((int)3, (int)3, (Random)random, (double[])singularValues);
        return M_inv;
    }

    public static DMatrixRMaj nextPositiveDefiniteMatrix(Random random, double singularValueMin, double singularValueMax) {
        DMatrixRMaj M = RandomMatrices_DDRM.diagonal((int)3, (double)singularValueMin, (double)singularValueMax, (Random)random);
        DMatrixRMaj P = ContactImpulseRandomTools.nextSquareFullRank(random);
        DMatrixRMaj Pinv = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.invert((DMatrixRMaj)P, (DMatrixRMaj)Pinv);
        DMatrixRMaj PM = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.mult((DMatrix1Row)P, (DMatrix1Row)M, (DMatrix1Row)PM);
        DMatrixRMaj PMPinv = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.mult((DMatrix1Row)PM, (DMatrix1Row)Pinv, (DMatrix1Row)PMPinv);
        return PMPinv;
    }

    public static DMatrixRMaj nextPositiveDefiniteSymmetricMatrix(Random random, double min, double max) {
        return RandomMatrices_DDRM.symmetricWithEigenvalues((int)3, (Random)random, (double[])RandomNumbers.nextDoubleArray((Random)random, (int)3, (double)min, (double)max));
    }

    public static DMatrixRMaj nextSlippingClosingVelocity(Random random, DMatrixRMaj M_inv, double mu) {
        DMatrixRMaj lambda_v_0 = new DMatrixRMaj(3, 1);
        lambda_v_0.set(2, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0));
        double minFrictionImpulse = mu * lambda_v_0.get(2);
        double frictionImpulse = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.01, (double)10.0) * minFrictionImpulse;
        double theta = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
        lambda_v_0.set(0, frictionImpulse * Math.cos(theta));
        lambda_v_0.set(1, frictionImpulse * Math.sin(theta));
        DMatrixRMaj c = ContactImpulseTools.negateMult(M_inv, lambda_v_0);
        if (c.get(2) > 0.0) {
            for (double alpha = theta; alpha < theta + Math.PI * 2; alpha += 0.3141592653589793) {
                lambda_v_0.set(0, frictionImpulse * Math.cos(alpha));
                lambda_v_0.set(1, frictionImpulse * Math.sin(alpha));
                c = ContactImpulseTools.negateMult(M_inv, lambda_v_0);
                if (!(c.get(2) < 0.0)) continue;
                return c;
            }
            return null;
        }
        return c;
    }
}

