/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.physics;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBox3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameCapsule3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameCylinder3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameEllipsoid3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePointShape3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameRamp3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameSphere3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.polytope.interfaces.FrameConvexPolytope3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Face3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.MeshDataBuilder;
import us.ihmc.graphicsDescription.MeshDataGenerator;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicShape;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.robotics.physics.Collidable;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoseUsingYawPitchRoll;
import us.ihmc.yoVariables.registry.YoRegistry;

public class CollidableVisualizer {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final Collidable collidable;
    private final Shape3DGraphicUpdater shape3DGraphicUpdater;

    public CollidableVisualizer(String name, String groupName, Collidable collidable, AppearanceDefinition appearanceDefinition, YoRegistry registry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.collidable = collidable;
        if (collidable.getShape() instanceof FrameSphere3DReadOnly) {
            this.shape3DGraphicUpdater = new Sphere3DGraphicUpdater(name, (FrameSphere3DReadOnly)collidable.getShape(), registry, appearanceDefinition);
        } else if (collidable.getShape() instanceof FrameBox3DReadOnly) {
            this.shape3DGraphicUpdater = new Box3DGraphicUpdater(name, (FrameBox3DReadOnly)collidable.getShape(), registry, appearanceDefinition);
        } else if (collidable.getShape() instanceof FrameRamp3DReadOnly) {
            this.shape3DGraphicUpdater = new Ramp3DGraphicUpdater(name, (FrameRamp3DReadOnly)collidable.getShape(), registry, appearanceDefinition);
        } else if (collidable.getShape() instanceof FrameCapsule3DReadOnly) {
            this.shape3DGraphicUpdater = new Capsule3DGraphicUpdater(name, (FrameCapsule3DReadOnly)collidable.getShape(), registry, appearanceDefinition);
        } else if (collidable.getShape() instanceof FrameCylinder3DReadOnly) {
            this.shape3DGraphicUpdater = new Cylinder3DGraphicUpdater(name, (FrameCylinder3DReadOnly)collidable.getShape(), registry, appearanceDefinition);
        } else if (collidable.getShape() instanceof FramePointShape3DReadOnly) {
            this.shape3DGraphicUpdater = new Point3DGraphicUpdater(name, (FramePointShape3DReadOnly)collidable.getShape(), registry, appearanceDefinition);
        } else if (collidable.getShape() instanceof FrameConvexPolytope3DReadOnly) {
            this.shape3DGraphicUpdater = new ConvexPolytope3DGraphicUpdater(name, (FrameConvexPolytope3DReadOnly)collidable.getShape(), registry, appearanceDefinition);
        } else if (collidable.getShape() instanceof FrameEllipsoid3DReadOnly) {
            this.shape3DGraphicUpdater = new EllipsoidGraphicUpdater(name, (FrameEllipsoid3DReadOnly)collidable.getShape(), registry, appearanceDefinition);
        } else {
            throw new UnsupportedOperationException("Unsupported type of shape: " + collidable.getShape().getClass().getSimpleName());
        }
        this.hide();
        yoGraphicsListRegistry.registerYoGraphic(groupName, this.shape3DGraphicUpdater.getYoGraphic());
    }

    public void hide() {
        this.shape3DGraphicUpdater.hide();
    }

    public void update() {
        this.shape3DGraphicUpdater.update();
    }

    public Collidable getCollidable() {
        return this.collidable;
    }

    public static MeshDataHolder newConvexPolytope3DMesh(ConvexPolytope3DReadOnly convexPolytope3D) {
        MeshDataBuilder meshBuilder = new MeshDataBuilder();
        for (Face3DReadOnly face : convexPolytope3D.getFaces()) {
            List ccwFaceVertices = face.getVertices().stream().map(Point3D::new).collect(Collectors.toList());
            Collections.reverse(ccwFaceVertices);
            meshBuilder.addMesh(MeshDataGenerator.Polygon(ccwFaceVertices));
        }
        return meshBuilder.generateMeshDataHolder();
    }

    private static class Sphere3DGraphicUpdater
    implements Shape3DGraphicUpdater {
        private final YoFramePoint3D position;
        private final YoGraphicPosition graphicSphere;
        private final FrameSphere3DReadOnly shape;
        FramePoint3D tempPoint = new FramePoint3D();

        public Sphere3DGraphicUpdater(String name, FrameSphere3DReadOnly shape, YoRegistry registry, AppearanceDefinition appearanceDefinition) {
            this.shape = shape;
            this.position = new YoFramePoint3D(name, worldFrame, registry);
            double radius = shape.getRadius();
            this.graphicSphere = new YoGraphicPosition(name, this.position, radius, appearanceDefinition);
        }

        @Override
        public void hide() {
            this.position.setToNaN();
        }

        @Override
        public void update() {
            this.tempPoint.setIncludingFrame((FrameTuple3DReadOnly)this.shape.getPosition());
            this.position.setMatchingFrame((FrameTuple3DReadOnly)this.tempPoint);
        }

        @Override
        public YoGraphic getYoGraphic() {
            return this.graphicSphere;
        }
    }

    private static interface Shape3DGraphicUpdater {
        public void hide();

        public void update();

        public YoGraphic getYoGraphic();
    }

    private static class Box3DGraphicUpdater
    implements Shape3DGraphicUpdater {
        private final YoFramePoseUsingYawPitchRoll pose;
        private final YoGraphicShape graphicBox;
        private final FrameBox3DReadOnly shape;
        private final FramePose3D tempPose = new FramePose3D();

        public Box3DGraphicUpdater(String name, FrameBox3DReadOnly shape, YoRegistry registry, AppearanceDefinition appearanceDefinition) {
            this.shape = shape;
            this.pose = new YoFramePoseUsingYawPitchRoll(name, worldFrame, registry);
            Graphics3DObject boxGraphicDefinition = new Graphics3DObject();
            boxGraphicDefinition.addCube(shape.getSizeX(), shape.getSizeY(), shape.getSizeZ(), true, appearanceDefinition);
            this.graphicBox = new YoGraphicShape(name, boxGraphicDefinition, this.pose, 1.0);
        }

        @Override
        public void hide() {
            this.pose.setToNaN();
        }

        @Override
        public void update() {
            this.tempPose.setIncludingFrame(this.shape.getReferenceFrame(), (RigidBodyTransformReadOnly)this.shape.getPose());
            this.pose.setMatchingFrame((FramePose3DReadOnly)this.tempPose);
        }

        @Override
        public YoGraphic getYoGraphic() {
            return this.graphicBox;
        }
    }

    private static class Ramp3DGraphicUpdater
    implements Shape3DGraphicUpdater {
        private final YoFramePoseUsingYawPitchRoll pose;
        private final YoGraphicShape graphicBox;
        private final FrameRamp3DReadOnly shape;
        private final FramePose3D tempPose = new FramePose3D();

        public Ramp3DGraphicUpdater(String name, FrameRamp3DReadOnly shape, YoRegistry registry, AppearanceDefinition appearanceDefinition) {
            this.shape = shape;
            this.pose = new YoFramePoseUsingYawPitchRoll(name, worldFrame, registry);
            Graphics3DObject rampGraphicDefinition = new Graphics3DObject();
            rampGraphicDefinition.translate(0.5 * shape.getSizeX(), 0.0, 0.0);
            rampGraphicDefinition.addWedge(shape.getSizeX(), shape.getSizeY(), shape.getSizeZ(), appearanceDefinition);
            this.graphicBox = new YoGraphicShape(name, rampGraphicDefinition, this.pose, 1.0);
            this.update();
        }

        @Override
        public void hide() {
            this.pose.setToNaN();
        }

        @Override
        public void update() {
            this.tempPose.setIncludingFrame(this.shape.getReferenceFrame(), (RigidBodyTransformReadOnly)this.shape.getPose());
            this.pose.setMatchingFrame((FramePose3DReadOnly)this.tempPose);
        }

        @Override
        public YoGraphic getYoGraphic() {
            return this.graphicBox;
        }
    }

    private static class Capsule3DGraphicUpdater
    implements Shape3DGraphicUpdater {
        private final YoFramePoseUsingYawPitchRoll pose;
        private final YoGraphicShape graphicCapsule;
        private final FrameCapsule3DReadOnly shape;
        private final FramePose3D tempPose = new FramePose3D();

        public Capsule3DGraphicUpdater(String name, FrameCapsule3DReadOnly shape, YoRegistry registry, AppearanceDefinition appearanceDefinition) {
            this.shape = shape;
            this.pose = new YoFramePoseUsingYawPitchRoll(name, worldFrame, registry);
            Graphics3DObject capsuleGraphicDefinition = new Graphics3DObject();
            double radius = shape.getRadius();
            double length = shape.getLength();
            capsuleGraphicDefinition.addCapsule(radius, length + 2.0 * radius, appearanceDefinition);
            this.graphicCapsule = new YoGraphicShape(name, capsuleGraphicDefinition, this.pose, 1.0);
        }

        @Override
        public void hide() {
            this.pose.setToNaN();
        }

        @Override
        public void update() {
            this.tempPose.setReferenceFrame(this.shape.getReferenceFrame());
            this.tempPose.getPosition().set((FrameTuple3DReadOnly)this.shape.getPosition());
            EuclidGeometryTools.orientation3DFromZUpToVector3D((Vector3DReadOnly)this.shape.getAxis(), (Orientation3DBasics)this.tempPose.getOrientation());
            this.pose.setMatchingFrame((FramePose3DReadOnly)this.tempPose);
        }

        @Override
        public YoGraphic getYoGraphic() {
            return this.graphicCapsule;
        }
    }

    private static class Cylinder3DGraphicUpdater
    implements Shape3DGraphicUpdater {
        private final YoFramePoseUsingYawPitchRoll pose;
        private final YoGraphicShape graphicCylinder;
        private final FrameCylinder3DReadOnly shape;
        private final FramePose3D tempPose = new FramePose3D();

        public Cylinder3DGraphicUpdater(String name, FrameCylinder3DReadOnly shape, YoRegistry registry, AppearanceDefinition appearanceDefinition) {
            this.shape = shape;
            this.pose = new YoFramePoseUsingYawPitchRoll(name, worldFrame, registry);
            Graphics3DObject cylinderGraphicDefinition = new Graphics3DObject();
            double radius = shape.getRadius();
            double length = shape.getLength();
            cylinderGraphicDefinition.translate(0.0, 0.0, -0.5 * length);
            cylinderGraphicDefinition.addCylinder(length, radius, appearanceDefinition);
            this.graphicCylinder = new YoGraphicShape(name, cylinderGraphicDefinition, this.pose, 1.0);
        }

        @Override
        public void hide() {
            this.pose.setToNaN();
        }

        @Override
        public void update() {
            this.tempPose.setReferenceFrame(this.shape.getReferenceFrame());
            this.tempPose.getPosition().set((FrameTuple3DReadOnly)this.shape.getPosition());
            EuclidGeometryTools.orientation3DFromZUpToVector3D((Vector3DReadOnly)this.shape.getAxis(), (Orientation3DBasics)this.tempPose.getOrientation());
            this.pose.setMatchingFrame((FramePose3DReadOnly)this.tempPose);
        }

        @Override
        public YoGraphic getYoGraphic() {
            return this.graphicCylinder;
        }
    }

    private static class Point3DGraphicUpdater
    implements Shape3DGraphicUpdater {
        private final YoFramePoint3D position;
        private final YoGraphicPosition graphicSphere;
        private final FramePointShape3DReadOnly shape;

        public Point3DGraphicUpdater(String name, FramePointShape3DReadOnly shape, YoRegistry registry, AppearanceDefinition appearanceDefinition) {
            this.shape = shape;
            this.position = new YoFramePoint3D(name, worldFrame, registry);
            this.graphicSphere = new YoGraphicPosition(name, this.position, 0.01, appearanceDefinition);
        }

        @Override
        public void hide() {
            this.position.setToNaN();
        }

        @Override
        public void update() {
            this.position.setMatchingFrame((FrameTuple3DReadOnly)this.shape);
        }

        @Override
        public YoGraphic getYoGraphic() {
            return this.graphicSphere;
        }
    }

    private static class ConvexPolytope3DGraphicUpdater
    implements Shape3DGraphicUpdater {
        private final YoFramePoseUsingYawPitchRoll pose;
        private final YoGraphicShape graphicConvexPolytope;
        private final FrameConvexPolytope3DReadOnly shape;

        public ConvexPolytope3DGraphicUpdater(String name, FrameConvexPolytope3DReadOnly shape, YoRegistry registry, AppearanceDefinition appearanceDefinition) {
            this.shape = shape;
            this.pose = new YoFramePoseUsingYawPitchRoll(name, worldFrame, registry);
            Graphics3DObject convexPolytopeGraphicDefinition = new Graphics3DObject();
            convexPolytopeGraphicDefinition.addMeshData(CollidableVisualizer.newConvexPolytope3DMesh((ConvexPolytope3DReadOnly)shape), appearanceDefinition);
            this.graphicConvexPolytope = new YoGraphicShape(name, convexPolytopeGraphicDefinition, this.pose, 1.0);
        }

        @Override
        public void hide() {
            this.pose.setToNaN();
        }

        @Override
        public void update() {
            this.pose.setFromReferenceFrame(this.shape.getReferenceFrame());
        }

        @Override
        public YoGraphic getYoGraphic() {
            return this.graphicConvexPolytope;
        }
    }

    private static class EllipsoidGraphicUpdater
    implements Shape3DGraphicUpdater {
        private final YoFramePoseUsingYawPitchRoll pose;
        private final YoGraphicShape graphicEllipsoid;
        private final FrameEllipsoid3DReadOnly shape;
        private final FramePose3D tempPose = new FramePose3D();

        public EllipsoidGraphicUpdater(String name, FrameEllipsoid3DReadOnly shape, YoRegistry registry, AppearanceDefinition appearanceDefinition) {
            this.shape = shape;
            this.pose = new YoFramePoseUsingYawPitchRoll(name, worldFrame, registry);
            Graphics3DObject ellipsoidGraphicDefinition = new Graphics3DObject();
            ellipsoidGraphicDefinition.addEllipsoid(shape.getRadiusX(), shape.getRadiusY(), shape.getRadiusZ(), appearanceDefinition);
            this.graphicEllipsoid = new YoGraphicShape(name, ellipsoidGraphicDefinition, this.pose, 1.0);
        }

        @Override
        public void hide() {
            this.pose.setToNaN();
        }

        @Override
        public void update() {
            this.tempPose.setReferenceFrame(this.shape.getReferenceFrame());
            this.tempPose.set((RigidBodyTransformReadOnly)this.shape.getPose());
            this.pose.setMatchingFrame((FramePose3DReadOnly)this.tempPose);
        }

        @Override
        public YoGraphic getYoGraphic() {
            return this.graphicEllipsoid;
        }
    }
}

