/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.optimization.constrainedOptimization;

import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.optimization.CostFunction;
import us.ihmc.robotics.optimization.constrainedOptimization.AugmentedLagrangeConstructor;
import us.ihmc.robotics.optimization.constrainedOptimization.AugmentedLagrangeOptimizationProblem;
import us.ihmc.robotics.optimization.constrainedOptimization.BlockConstraintFunction;

public class MultiblockADMMProblem {
    private final List<AugmentedLagrangeOptimizationProblem> isolatedOptimizationProblems = new ArrayList<AugmentedLagrangeOptimizationProblem>();
    private final List<BlockConstraintFunction> inequalityConstraints = new ArrayList<BlockConstraintFunction>();
    private final List<BlockConstraintFunction> equalityConstraints = new ArrayList<BlockConstraintFunction>();
    private AugmentedLagrangeConstructor multiblockAugmentedLagrangeConstructor;
    private DMatrixD1[] optimalBlocksFromLastIteration;

    public void addIsolatedProblem(AugmentedLagrangeOptimizationProblem isolatedProblem) {
        this.isolatedOptimizationProblems.add(isolatedProblem);
    }

    public void addInequalityConstraint(BlockConstraintFunction constraint) {
        this.inequalityConstraints.add(constraint);
    }

    public void addEqualityConstraint(BlockConstraintFunction constraint) {
        this.equalityConstraints.add(constraint);
    }

    public void clearConstraints() {
        this.equalityConstraints.clear();
        this.inequalityConstraints.clear();
    }

    public void clearIsolatedProblems() {
        this.isolatedOptimizationProblems.clear();
    }

    public void initialize(double penalty, double penaltyIncreaseFactor) {
        for (AugmentedLagrangeOptimizationProblem problem : this.isolatedOptimizationProblems) {
            problem.initialize(penalty, penaltyIncreaseFactor);
        }
        this.multiblockAugmentedLagrangeConstructor = new AugmentedLagrangeConstructor(penalty, penaltyIncreaseFactor, this.equalityConstraints.size(), this.inequalityConstraints.size());
    }

    public CostFunction getAugmentedCostFunctionForBlock(final int blockIndex) {
        return new CostFunction(){

            @Override
            public double calculate(DMatrixD1 x) {
                return MultiblockADMMProblem.this.calculateDualCostForBlock(blockIndex, x, MultiblockADMMProblem.this.optimalBlocksFromLastIteration);
            }
        };
    }

    public double calculateDualCostForBlock(int blockIndex, DMatrixD1 x, DMatrixD1[] optimalBlocksForLastIteration) {
        if (optimalBlocksForLastIteration.length != this.getNumBlocks()) {
            throw new RuntimeException("Not enough blocks " + optimalBlocksForLastIteration.length + " were provided for all blocks of the problem " + this.getNumBlocks());
        }
        DMatrixD1[] blocksCopy = (DMatrixD1[])optimalBlocksForLastIteration.clone();
        blocksCopy[blockIndex] = x;
        return this.calculateDualCostForBlock(blockIndex, blocksCopy);
    }

    private double calculateDualCostForBlock(int blockIndex, DMatrixD1[] blocks) {
        double isolatedCost = this.isolatedOptimizationProblems.get(blockIndex).calculateDualProblemCost(blocks[blockIndex]);
        DMatrixD1 inequalityConstraintEvaluations = this.evaluateGlobalInequalityConstraints(blocks);
        DMatrixD1 equalityConstraintEvaluations = this.evaluateEqualityConstraints(blocks);
        return this.multiblockAugmentedLagrangeConstructor.getAugmentedLagrangeCost(isolatedCost, equalityConstraintEvaluations, inequalityConstraintEvaluations);
    }

    private DMatrixD1 evaluateGlobalInequalityConstraints(DMatrixD1[] blocks) {
        int numConstraints = this.inequalityConstraints.size();
        DMatrixRMaj value = new DMatrixRMaj(numConstraints, 1);
        for (int i = 0; i < numConstraints; ++i) {
            value.set(i, this.inequalityConstraints.get(i).calculate(blocks));
        }
        return value;
    }

    private DMatrixD1 evaluateEqualityConstraints(DMatrixD1[] blocks) {
        int numConstraints = this.equalityConstraints.size();
        DMatrixRMaj value = new DMatrixRMaj(numConstraints, 1);
        for (int i = 0; i < numConstraints; ++i) {
            value.set(i, this.equalityConstraints.get(i).calculate(blocks));
        }
        return value;
    }

    public void updateLagrangeMultipliers(DMatrixD1[] optimalBlocks) {
        if (optimalBlocks.length != this.getNumBlocks()) {
            throw new RuntimeException("Not enough values " + optimalBlocks.length + " were provided for all blocks of the problem " + this.getNumBlocks());
        }
        this.multiblockAugmentedLagrangeConstructor.updateLagrangeMultipliers(this.evaluateEqualityConstraints(optimalBlocks), this.evaluateGlobalInequalityConstraints(optimalBlocks));
        for (int i = 0; i < this.isolatedOptimizationProblems.size(); ++i) {
            AugmentedLagrangeOptimizationProblem problem = this.isolatedOptimizationProblems.get(i);
            problem.updateLagrangeMultipliers(optimalBlocks[i]);
        }
    }

    public void saveOptimalBlocksForLastIteration(DMatrixD1[] optimalBlocks) {
        if (optimalBlocks.length != this.getNumBlocks()) {
            throw new RuntimeException("Not enough values " + optimalBlocks.length + " were provided for all blocks of the problem " + this.getNumBlocks());
        }
        this.optimalBlocksFromLastIteration = optimalBlocks;
    }

    public List<AugmentedLagrangeOptimizationProblem> getIsolatedOptimizationProblems() {
        return this.isolatedOptimizationProblems;
    }

    public int getNumBlocks() {
        return this.isolatedOptimizationProblems.size();
    }

    public void printResults(DMatrixD1[] blocks) {
        this.printResults(this.evaluateEqualityConstraints(blocks), this.evaluateGlobalInequalityConstraints(blocks), blocks);
    }

    public void printResults(DMatrixD1 equalityEvaluations, DMatrixD1 inequalityEvaluations, DMatrixD1[] blocks) {
        int i;
        LogTools.info((String)"");
        for (i = 0; i < this.isolatedOptimizationProblems.size(); ++i) {
            System.out.println("-- Isolated Problem " + i + ": --");
            this.isolatedOptimizationProblems.get(i).printResults(blocks[i]);
        }
        if (equalityEvaluations.getNumElements() > 0) {
            System.out.println("-- Global Equality Constraints J(x[]): --");
            for (i = 0; i < equalityEvaluations.getNumElements(); ++i) {
                System.out.println("\t" + equalityEvaluations.get(i) + " == 0");
            }
        }
        if (inequalityEvaluations.getNumElements() > 0) {
            System.out.println("-- Global Inquality Constraints K(x[]): --");
            for (i = 0; i < inequalityEvaluations.getNumElements(); ++i) {
                System.out.println("\t" + inequalityEvaluations.get(i) + " >= 0");
            }
        }
    }
}

