/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.optimization.constrainedOptimization;

import org.ejml.data.DMatrixD1;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.optimization.Optimizer;
import us.ihmc.robotics.optimization.constrainedOptimization.AugmentedLagrangeOptimizationProblem;
import us.ihmc.robotics.optimization.constrainedOptimization.MultiblockADMMProblem;

public class MultiblockADMMOptimizer {
    private final MultiblockADMMProblem admm;
    private final Optimizer[] optimizers;
    private boolean verbose = true;

    public MultiblockADMMOptimizer(MultiblockADMMProblem admm, Optimizer[] optimizers) {
        this.admm = admm;
        this.optimizers = optimizers;
        if (optimizers.length != admm.getNumBlocks()) {
            throw new RuntimeException("Not enough optimizers " + optimizers.length + " were provided for all blocks of the problem " + admm.getNumBlocks());
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public DMatrixD1[] solveOverNIterations(int numLagrangeIterations, DMatrixD1[] initialValues) {
        int i;
        if (initialValues.length != this.admm.getNumBlocks()) {
            throw new RuntimeException("Not enough initial values " + initialValues.length + " were provided for all blocks of the problem " + this.admm.getNumBlocks());
        }
        int numBlocks = this.admm.getNumBlocks();
        DMatrixD1[] optima = new DMatrixD1[numBlocks];
        for (int i2 = 0; i2 < numBlocks; ++i2) {
            AugmentedLagrangeOptimizationProblem problem = this.admm.getIsolatedOptimizationProblems().get(i2);
            this.optimizers[i2].setCostFunction(problem.getAugmentedCostFunction());
            optima[i2] = this.optimizers[i2].optimize(initialValues[i2]);
        }
        if (this.verbose) {
            LogTools.info((String)"");
            System.out.println("===== Initial Seed ===============");
            this.admm.printResults(optima);
        }
        this.admm.updateLagrangeMultipliers(optima);
        this.admm.saveOptimalBlocksForLastIteration(optima);
        int iteration = 0;
        for (i = 0; i < numBlocks; ++i) {
            this.optimizers[i].setCostFunction(this.admm.getAugmentedCostFunctionForBlock(i));
        }
        while (iteration < numLagrangeIterations) {
            for (i = 0; i < numBlocks; ++i) {
                optima[i] = this.optimizers[i].optimize(optima[i]);
            }
            this.admm.updateLagrangeMultipliers(optima);
            this.admm.saveOptimalBlocksForLastIteration(optima);
            ++iteration;
            if (!this.verbose) continue;
            LogTools.info((String)"");
            System.out.println("===== Lagrange Iteration: " + iteration + " ==========");
            this.admm.printResults(optima);
        }
        return optima;
    }
}

