/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.optimization.constrainedOptimization;

import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.optimization.CostFunction;
import us.ihmc.robotics.optimization.constrainedOptimization.AugmentedLagrangeConstructor;
import us.ihmc.robotics.optimization.constrainedOptimization.ConstraintFunction;

public class AugmentedLagrangeOptimizationProblem {
    private final CostFunction costFunction;
    private final List<ConstraintFunction> inequalityConstraints = new ArrayList<ConstraintFunction>();
    private final List<ConstraintFunction> equalityConstraints = new ArrayList<ConstraintFunction>();
    private AugmentedLagrangeConstructor augmentedLagrangeConstructor;

    public AugmentedLagrangeOptimizationProblem(CostFunction costFunction) {
        this.costFunction = costFunction;
    }

    public void addInequalityConstraint(ConstraintFunction constraint) {
        this.inequalityConstraints.add(constraint);
    }

    public void addEqualityConstraint(ConstraintFunction constraint) {
        this.equalityConstraints.add(constraint);
    }

    public void clearConstraints() {
        this.equalityConstraints.clear();
        this.inequalityConstraints.clear();
    }

    public void initialize(double initialPenalty, double penaltyIncreaseFactor) {
        this.augmentedLagrangeConstructor = new AugmentedLagrangeConstructor(initialPenalty, penaltyIncreaseFactor, this.equalityConstraints.size(), this.inequalityConstraints.size());
    }

    public CostFunction getAugmentedCostFunction() {
        return this::calculateDualProblemCost;
    }

    public double calculateDualProblemCost(DMatrixD1 x) {
        double objectivesCost = this.calculateCost(x);
        DMatrixD1 inequalityConstraintEvaluations = this.evaluateInequalityConstraints(x);
        DMatrixD1 equalityConstraintEvaluations = this.evaluateEqualityConstraints(x);
        return this.augmentedLagrangeConstructor.getAugmentedLagrangeCost(objectivesCost, equalityConstraintEvaluations, inequalityConstraintEvaluations);
    }

    private double calculateCost(DMatrixD1 x) {
        return this.costFunction.calculate(x);
    }

    private DMatrixD1 evaluateInequalityConstraints(DMatrixD1 x) {
        int numConstraints = this.inequalityConstraints.size();
        DMatrixRMaj value = new DMatrixRMaj(numConstraints, 1);
        for (int i = 0; i < numConstraints; ++i) {
            value.set(i, this.inequalityConstraints.get(i).calculate(x));
        }
        return value;
    }

    private DMatrixD1 evaluateEqualityConstraints(DMatrixD1 x) {
        int numConstraints = this.equalityConstraints.size();
        DMatrixRMaj value = new DMatrixRMaj(numConstraints, 1);
        for (int i = 0; i < numConstraints; ++i) {
            value.set(i, this.equalityConstraints.get(i).calculate(x));
        }
        return new DMatrixRMaj(value);
    }

    public void updateLagrangeMultipliers(DMatrixD1 xOptimal) {
        this.augmentedLagrangeConstructor.updateLagrangeMultipliers(this.evaluateEqualityConstraints(xOptimal), this.evaluateInequalityConstraints(xOptimal));
    }

    public void printResults(DMatrixD1 x) {
        this.printResults(x, this.costFunction.calculate(x), this.evaluateEqualityConstraints(x), this.evaluateInequalityConstraints(x));
    }

    public void printResults(DMatrixD1 x, double cost, DMatrixD1 equalityEvaluations, DMatrixD1 inequalityEvaluations) {
        int i;
        LogTools.info((String)"");
        System.out.println("Solution x:");
        for (i = 0; i < x.getNumElements(); ++i) {
            LogTools.debug((String)("\t" + x.get(i) + ","));
        }
        System.out.println("Cost f(x):");
        System.out.println("\t" + cost);
        if (equalityEvaluations.getNumElements() > 0) {
            System.out.println("Equality Constraints G(x):");
            for (i = 0; i < equalityEvaluations.getNumElements(); ++i) {
                System.out.println("\t" + equalityEvaluations.get(i) + " == 0");
            }
        }
        if (inequalityEvaluations.getNumElements() > 0) {
            System.out.println("Inquality Constraints H(x):");
            for (i = 0; i < inequalityEvaluations.getNumElements(); ++i) {
                System.out.println("\t" + inequalityEvaluations.get(i) + " >= 0");
            }
        }
    }
}

