/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.optimization;

import org.ejml.data.DMatrixRMaj;

public class QuadraticProgram {
    private final DMatrixRMaj a;
    private final DMatrixRMaj b;
    private final DMatrixRMaj c;
    private final DMatrixRMaj d;

    public QuadraticProgram(DMatrixRMaj a, DMatrixRMaj b, DMatrixRMaj c, DMatrixRMaj d) {
        this.doSizeChecks(a, b, c, d);
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    private void doSizeChecks(DMatrixRMaj a, DMatrixRMaj b, DMatrixRMaj c, DMatrixRMaj d) {
        if (a.getNumRows() != b.getNumRows()) {
            throw new IllegalArgumentException("a.getNumRows() != b.getNumRows()");
        }
        if (c.getNumRows() != d.getNumRows()) {
            throw new IllegalArgumentException("c.getNumRows() != d.getNumRows()");
        }
        if (a.getNumCols() != c.getNumCols()) {
            throw new IllegalArgumentException("a.getNumCols() != c.getNumCols()");
        }
    }

    public DMatrixRMaj getA() {
        return this.a;
    }

    public DMatrixRMaj getB() {
        return this.b;
    }

    public DMatrixRMaj getC() {
        return this.c;
    }

    public DMatrixRMaj getD() {
        return this.d;
    }

    public int getSolutionSize() {
        return this.a.getNumCols();
    }

    public int getObjectiveSize() {
        return this.b.getNumRows();
    }

    public int getInequalityConstraintSize() {
        return this.d.getNumRows();
    }
}

