/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.optimization;

import java.util.Set;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.mult.VectorVectorMult_DDRM;
import us.ihmc.commons.MathTools;
import us.ihmc.robotics.optimization.ActiveSearchOptimizationSettings;
import us.ihmc.robotics.optimization.ActiveSearchSolutionInfo;
import us.ihmc.robotics.optimization.EqualityConstraintEnforcer;
import us.ihmc.robotics.optimization.QuadraticProgram;

public class ActiveSearchQuadraticProgramOptimizer {
    private QuadraticProgram quadraticProgram;
    private final ActiveSearchOptimizationSettings settings;
    private final ActiveSearchSolutionInfo solutionInfo = new ActiveSearchSolutionInfo();
    private final EqualityConstraintEnforcer equalityConstraintEnforcer;
    private final DMatrixRMaj cX = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj aCopy = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj bCopy = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj cActive = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj dActive = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj xBarStar = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj ci = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj step = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj axMinusB = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj lambda = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj aCPlus = new DMatrixRMaj(1, 1);

    public ActiveSearchQuadraticProgramOptimizer(ActiveSearchOptimizationSettings settings) {
        this.settings = settings;
        this.equalityConstraintEnforcer = new EqualityConstraintEnforcer(settings.getLinearSolver());
    }

    public void setQuadraticProgram(QuadraticProgram quadraticProgram) {
        this.quadraticProgram = quadraticProgram;
    }

    private void setInitialGuess(DMatrixRMaj initialGuess) {
        this.solutionInfo.setSolution(initialGuess);
        this.determineActiveSet(initialGuess);
    }

    private void determineActiveSet(DMatrixRMaj x) {
        this.solutionInfo.clearActiveSet();
        DMatrixRMaj c = this.quadraticProgram.getC();
        DMatrixRMaj d = this.quadraticProgram.getD();
        this.cX.reshape(this.quadraticProgram.getInequalityConstraintSize(), 1);
        CommonOps_DDRM.mult((DMatrix1Row)c, (DMatrix1Row)x, (DMatrix1Row)this.cX);
        for (int i = 0; i < this.cX.getNumRows(); ++i) {
            double di;
            double cXi = this.cX.get(i, 0);
            if (MathTools.epsilonEquals((double)cXi, (double)(di = d.get(i, 0)), (double)this.settings.getEpsilonConstraintActive())) {
                this.solutionInfo.getActiveSet().add(i);
                continue;
            }
            if (!(cXi >= di)) continue;
            throw new RuntimeException("x is not feasible!");
        }
    }

    public void solve(DMatrixRMaj initialGuess) {
        if (this.quadraticProgram == null) {
            throw new RuntimeException("Quadratic program has not been set!");
        }
        this.solutionInfo.reset(this.quadraticProgram.getSolutionSize());
        this.setInitialGuess(initialGuess);
        while (!this.solutionInfo.isConverged() && this.solutionInfo.getIterations() < this.settings.getMaxIterations()) {
            this.solutionInfo.setConverged(true);
            this.updateActiveConstraintEquation();
            DMatrixRMaj xStar = this.computeOptimumForCurrentActiveSet();
            DMatrixRMaj x = this.solutionInfo.getSolution();
            this.step.set((DMatrixD1)xStar);
            CommonOps_DDRM.subtractEquals((DMatrixD1)this.step, (DMatrixD1)x);
            this.ci.reshape(1, this.quadraticProgram.getSolutionSize());
            double tau = 1.0;
            int newActiveConstraintIndex = -1;
            for (int constraintIndex = 0; constraintIndex < this.quadraticProgram.getInequalityConstraintSize(); ++constraintIndex) {
                if (this.solutionInfo.getActiveSet().contains(constraintIndex)) continue;
                CommonOps_DDRM.extract((DMatrix)this.quadraticProgram.getC(), (int)constraintIndex, (int)(constraintIndex + 1), (int)0, (int)this.quadraticProgram.getSolutionSize(), (DMatrix)this.ci, (int)0, (int)0);
                double di = this.quadraticProgram.getD().get(constraintIndex, 0);
                double ciX = VectorVectorMult_DDRM.innerProd((DMatrixD1)this.ci, (DMatrixD1)x);
                double ciStep = VectorVectorMult_DDRM.innerProd((DMatrixD1)this.ci, (DMatrixD1)this.step);
                double tauI = -(ciX - di) / ciStep;
                if (!(tauI < tau)) continue;
                tau = tauI;
                newActiveConstraintIndex = constraintIndex;
            }
            this.updateSolution(tau);
            this.decreaseActiveSetIfNecessary();
            this.increaseActiveSetIfNecessary(newActiveConstraintIndex);
            this.solutionInfo.incrementIterations();
        }
    }

    private void updateActiveConstraintEquation() {
        Set<Integer> activeSet = this.solutionInfo.getActiveSet();
        int nActiveConstraints = activeSet.size();
        DMatrixRMaj c = this.quadraticProgram.getC();
        DMatrixRMaj d = this.quadraticProgram.getD();
        this.cActive.reshape(nActiveConstraints, this.quadraticProgram.getSolutionSize());
        this.dActive.reshape(nActiveConstraints, 1);
        int activeConstraintIndex = 0;
        for (Integer constraintIndex : activeSet) {
            CommonOps_DDRM.extract((DMatrix)c, (int)constraintIndex, (int)(constraintIndex + 1), (int)0, (int)this.quadraticProgram.getSolutionSize(), (DMatrix)this.cActive, (int)activeConstraintIndex, (int)0);
            this.dActive.set(activeConstraintIndex, 0, d.get(constraintIndex.intValue(), 0));
            ++activeConstraintIndex;
        }
    }

    private DMatrixRMaj computeOptimumForCurrentActiveSet() {
        this.aCopy.set((DMatrixD1)this.quadraticProgram.getA());
        this.bCopy.set((DMatrixD1)this.quadraticProgram.getB());
        this.equalityConstraintEnforcer.setConstraint(this.cActive, this.dActive);
        this.equalityConstraintEnforcer.constrainEquation(this.aCopy, this.bCopy);
        this.settings.getLinearSolver().setA((Matrix)this.aCopy);
        this.xBarStar.reshape(this.quadraticProgram.getSolutionSize(), 1);
        this.settings.getLinearSolver().solve((Matrix)this.bCopy, (Matrix)this.xBarStar);
        return this.equalityConstraintEnforcer.constrainResult(this.xBarStar);
    }

    private void increaseActiveSetIfNecessary(int newActiveConstraintIndex) {
        if (newActiveConstraintIndex >= 0) {
            this.solutionInfo.getActiveSet().add(newActiveConstraintIndex);
            this.solutionInfo.setConverged(false);
        }
    }

    private void decreaseActiveSetIfNecessary() {
        this.axMinusB.reshape(this.quadraticProgram.getObjectiveSize(), 1);
        CommonOps_DDRM.mult((DMatrix1Row)this.quadraticProgram.getA(), (DMatrix1Row)this.solutionInfo.getSolution(), (DMatrix1Row)this.axMinusB);
        CommonOps_DDRM.subtractEquals((DMatrixD1)this.axMinusB, (DMatrixD1)this.quadraticProgram.getB());
        this.aCPlus.reshape(this.quadraticProgram.getObjectiveSize(), this.cActive.getNumRows());
        CommonOps_DDRM.mult((DMatrix1Row)this.quadraticProgram.getA(), (DMatrix1Row)this.equalityConstraintEnforcer.getConstraintPseudoInverse(), (DMatrix1Row)this.aCPlus);
        this.lambda.reshape(this.cActive.getNumRows(), 1);
        CommonOps_DDRM.multTransA((DMatrix1Row)this.aCPlus, (DMatrix1Row)this.axMinusB, (DMatrix1Row)this.lambda);
        CommonOps_DDRM.changeSign((DMatrixD1)this.lambda);
        double nu = Double.POSITIVE_INFINITY;
        Integer superfluousActiveConstraintIndex = null;
        int activeConstraintIndex = 0;
        for (Integer constraintIndex : this.solutionInfo.getActiveSet()) {
            int n = activeConstraintIndex++;
            double lambdaI = this.lambda.get(n, 0);
            if (!(lambdaI < nu)) continue;
            nu = lambdaI;
            superfluousActiveConstraintIndex = constraintIndex;
        }
        if (nu < 0.0) {
            this.solutionInfo.getActiveSet().remove(superfluousActiveConstraintIndex);
            this.solutionInfo.setConverged(false);
        }
    }

    private void updateSolution(double tau) {
        CommonOps_DDRM.scale((double)tau, (DMatrixD1)this.step);
        CommonOps_DDRM.addEquals((DMatrixD1)this.solutionInfo.getSolution(), (DMatrixD1)this.step);
    }

    public ActiveSearchSolutionInfo getSolutionInfo() {
        return this.solutionInfo;
    }
}

