/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.occupancyGrid;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.robotics.occupancyGrid.OccupancyGrid;
import us.ihmc.robotics.occupancyGrid.OccupancyGridCell;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class OccupancyGridVisualizer {
    private final List<YoFramePoint3D> cellViz = new ArrayList<YoFramePoint3D>();
    private final OccupancyGrid gridToVisualize;
    private final FramePoint3D positionInGrid = new FramePoint3D();

    public OccupancyGridVisualizer(String namePrefix, OccupancyGrid gridToVisualize, int maxPoints, YoRegistry registry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(namePrefix, gridToVisualize, maxPoints, YoAppearance.Orange(), registry, yoGraphicsListRegistry);
    }

    public OccupancyGridVisualizer(String namePrefix, OccupancyGrid gridToVisualize, int maxPoints, AppearanceDefinition color, YoRegistry registry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.gridToVisualize = gridToVisualize;
        for (int i = 0; i < maxPoints; ++i) {
            String namePrefix2 = "CellViz" + i;
            YoFramePoint3D pointForViz = new YoFramePoint3D(namePrefix + namePrefix2, ReferenceFrame.getWorldFrame(), registry);
            pointForViz.setToNaN();
            this.cellViz.add(pointForViz);
            YoGraphicPosition yoGraphicPosition = new YoGraphicPosition(namePrefix + namePrefix2, pointForViz, 0.004, color);
            yoGraphicsListRegistry.registerArtifact(namePrefix + "Visualizer", (Artifact)yoGraphicPosition.createArtifact());
        }
    }

    public void update() {
        int maxSize = this.gridToVisualize.getAllActiveCells().size();
        int cellCounter = 0;
        for (int i = 0; i < maxSize && cellCounter < this.cellViz.size(); ++i) {
            OccupancyGridCell cell = this.gridToVisualize.getAllActiveCells().get(i);
            if (!cell.getIsOccupied()) continue;
            this.positionInGrid.setIncludingFrame(this.gridToVisualize.getGridFrame(), this.gridToVisualize.getXLocation(cell.getXIndex()), this.gridToVisualize.getYLocation(cell.getYIndex()), 0.0);
            this.cellViz.get(cellCounter).setMatchingFrame((FrameTuple3DReadOnly)this.positionInGrid);
            ++cellCounter;
        }
        while (cellCounter < this.cellViz.size()) {
            this.cellViz.get(cellCounter).setToNaN();
            ++cellCounter;
        }
    }
}

