/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.occupancyGrid;

import com.esotericsoftware.kryo.util.IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.robotics.occupancyGrid.OccupancyGridCell;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class OccupancyGrid {
    static final double defaultCellSize = 0.01;
    private static final double defaultNoDecay = 0.0;
    private static final double defaultOneHitOccupancy = 1.0;
    private final YoDouble decayRate;
    private final YoDouble cellXSize;
    private final YoDouble cellYSize;
    private final YoDouble cellArea;
    private final YoInteger numberOfOccupiedCells;
    private final YoDouble thresholdForCellActivation;
    private final ReferenceFrame gridFrame;
    private final AtomicBoolean resetOccupancyGrid = new AtomicBoolean();
    final IntMap<OccupancyGridCell> occupancyCellMap = new IntMap();
    final List<OccupancyGridCell> allCellsPool = new ArrayList<OccupancyGridCell>();
    private final List<OccupancyGridCell> allActiveCells = new ArrayList<OccupancyGridCell>();

    public OccupancyGrid(String namePrefix, ReferenceFrame gridFrame, YoRegistry parentRegistry) {
        this.gridFrame = gridFrame;
        String name = this.getClass().getSimpleName();
        YoRegistry registry = new YoRegistry(namePrefix + name);
        this.cellXSize = new YoDouble(namePrefix + "CellXSize", registry);
        this.cellYSize = new YoDouble(namePrefix + "CellYSize", registry);
        this.cellArea = new YoDouble(namePrefix + "CellArea", registry);
        this.numberOfOccupiedCells = new YoInteger(namePrefix + "NumberOfOccupiedCells", registry);
        this.thresholdForCellActivation = new YoDouble(namePrefix + "ThresholdForCellOccupancy", registry);
        this.decayRate = new YoDouble(namePrefix + "CellOccupancyDecayRate", registry);
        this.thresholdForCellActivation.set(1.0);
        this.decayRate.set(0.0);
        this.cellXSize.set(0.01);
        this.cellYSize.set(0.01);
        this.setupChangedGridParameterListeners();
        parentRegistry.addChild(registry);
    }

    private void setupChangedGridParameterListeners() {
        YoVariableChangedListener changedGridSizeListener = v -> this.cellArea.set(this.cellXSize.getDoubleValue() * this.cellYSize.getDoubleValue());
        this.cellYSize.addListener(changedGridSizeListener);
        this.cellXSize.addListener(changedGridSizeListener);
        changedGridSizeListener.changed(null);
    }

    public void setThresholdForCellOccupancy(double thresholdForCellOccupancy) {
        this.thresholdForCellActivation.set(thresholdForCellOccupancy);
    }

    public void setOccupancyDecayRate(double occupancyDecayRate) {
        this.decayRate.set(occupancyDecayRate);
    }

    public void setCellSize(double size) {
        this.setCellXSize(size);
        this.setCellYSize(size);
    }

    public void setCellXSize(double xSize) {
        this.cellXSize.set(xSize);
        this.resetOccupancyGrid.set(true);
    }

    public void setCellYSize(double ySize) {
        this.cellYSize.set(ySize);
        this.resetOccupancyGrid.set(true);
    }

    public double getCellXSize() {
        return this.cellXSize.getDoubleValue();
    }

    public double getCellYSize() {
        return this.cellYSize.getDoubleValue();
    }

    public List<OccupancyGridCell> getAllActiveCells() {
        return this.allActiveCells;
    }

    public ReferenceFrame getGridFrame() {
        return this.gridFrame;
    }

    public void reset() {
        this.numberOfOccupiedCells.set(0);
        this.allActiveCells.clear();
        for (int i = 0; i < this.allCellsPool.size(); ++i) {
            this.allCellsPool.get(i).reset();
        }
    }

    public void update() {
        if (this.resetOccupancyGrid.getAndSet(false)) {
            this.reset();
        }
        this.numberOfOccupiedCells.set(0);
        for (int i = 0; i < this.allCellsPool.size(); ++i) {
            if (!this.allCellsPool.get(i).update()) continue;
            this.numberOfOccupiedCells.increment();
        }
    }

    public int registerPoint(FramePoint2DReadOnly point) {
        point.checkReferenceFrameMatch(this.gridFrame);
        OccupancyGridCell cell = this.getOrCreateOccupancyGridCell((Point2DReadOnly)point);
        boolean wasOccupied = cell.getIsOccupied();
        if (cell.registerHit() && !wasOccupied) {
            this.numberOfOccupiedCells.increment();
        }
        return this.numberOfOccupiedCells.getIntegerValue();
    }

    public int getNumberOfOccupiedCells() {
        return this.numberOfOccupiedCells.getIntegerValue();
    }

    public boolean isCellOccupied(double x, double y) {
        return this.isCellOccupied(this.findXIndex(x), this.findYIndex(y));
    }

    public boolean isCellOccupied(int xIndex, int yIndex) {
        OccupancyGridCell cell = this.getCell(xIndex, yIndex);
        if (cell != null) {
            return cell.getIsOccupied();
        }
        return false;
    }

    public double getXLocation(int xIndex) {
        return this.cellXSize.getDoubleValue() * (double)xIndex;
    }

    public double getYLocation(int yIndex) {
        return this.cellYSize.getDoubleValue() * (double)yIndex;
    }

    private int findXIndex(double x) {
        return OccupancyGrid.findIndex(x, this.cellXSize.getDoubleValue());
    }

    private int findYIndex(double y) {
        return OccupancyGrid.findIndex(y, this.cellYSize.getDoubleValue());
    }

    static int findIndex(double value, double gridSize) {
        return (int)Math.floor(value / gridSize);
    }

    private OccupancyGridCell getOrCreateOccupancyGridCell(Point2DReadOnly pointInGrid) {
        int xIndex = this.findXIndex(pointInGrid.getX());
        int yIndex = this.findYIndex(pointInGrid.getY());
        return this.getOrCreateOccupancyGridCell(xIndex, yIndex);
    }

    private OccupancyGridCell getCell(int xIndex, int yIndex) {
        int hashCode = OccupancyGridCell.computeHashCode(xIndex, yIndex);
        return (OccupancyGridCell)this.occupancyCellMap.get(hashCode);
    }

    private OccupancyGridCell createCell(int xIndex, int yIndex) {
        int hashCode = OccupancyGridCell.computeHashCode(xIndex, yIndex);
        OccupancyGridCell cell = new OccupancyGridCell(xIndex, yIndex, (DoubleProvider)this.thresholdForCellActivation, (DoubleProvider)this.decayRate);
        this.allCellsPool.add(cell);
        this.occupancyCellMap.put(hashCode, (Object)cell);
        return cell;
    }

    private OccupancyGridCell getOrCreateOccupancyGridCell(int xIndex, int yIndex) {
        OccupancyGridCell cell = this.getCell(xIndex, yIndex);
        if (cell == null) {
            cell = this.createCell(xIndex, yIndex);
        }
        if (!this.allActiveCells.contains(cell)) {
            this.allActiveCells.add(cell);
        }
        return cell;
    }
}

