/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints.interfaces;

import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.SO3WaypointReadOnly;

public interface SO3WaypointBasics
extends SO3WaypointReadOnly,
Transformable,
Clearable {
    public QuaternionBasics getOrientation();

    public Vector3DBasics getAngularVelocity();

    default public void setToNaN() {
        this.getOrientation().setToNaN();
        this.getAngularVelocity().setToNaN();
    }

    default public void setToZero() {
        this.getOrientation().setToZero();
        this.getAngularVelocity().setToZero();
    }

    @Override
    default public boolean containsNaN() {
        return SO3WaypointReadOnly.super.containsNaN();
    }

    default public void set(Orientation3DReadOnly orientation, Vector3DReadOnly angularVelocity) {
        this.getOrientation().set(orientation);
        this.getAngularVelocity().set((Tuple3DReadOnly)angularVelocity);
    }

    default public void set(SO3WaypointReadOnly other) {
        this.getOrientation().set(other.getOrientation());
        this.getAngularVelocity().set((Tuple3DReadOnly)other.getAngularVelocity());
    }

    default public void applyTransform(Transform transform) {
        this.getOrientation().applyTransform(transform);
        this.getAngularVelocity().applyTransform(transform);
    }

    default public void applyInverseTransform(Transform transform) {
        this.getOrientation().applyInverseTransform(transform);
        this.getAngularVelocity().applyInverseTransform(transform);
    }
}

