/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints.interfaces;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.robotics.math.trajectories.waypoints.SO3Waypoint;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameSO3WaypointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.SO3WaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.SO3WaypointReadOnly;

public interface FixedFrameSO3WaypointBasics
extends FrameSO3WaypointReadOnly,
SO3WaypointBasics {
    public FixedFrameQuaternionBasics getOrientation();

    public FixedFrameVector3DBasics getAngularVelocity();

    default public void set(FrameOrientation3DReadOnly orientation, FrameVector3DReadOnly angularVelocity) {
        this.getOrientation().set(orientation);
        this.getAngularVelocity().set((FrameTuple3DReadOnly)angularVelocity);
    }

    default public void set(FrameSO3WaypointReadOnly other) {
        this.set(other.getReferenceFrame(), other);
    }

    default public void set(ReferenceFrame referenceframe, SO3WaypointReadOnly other) {
        this.checkReferenceFrameMatch(referenceframe);
        this.set(other);
    }

    public static FixedFrameSO3WaypointBasics newFixedFrameSO3WaypointBasics(ReferenceFrameHolder referenceFrameHolder) {
        return FixedFrameSO3WaypointBasics.newLinkedFixedFrameSO3WaypointBasics(referenceFrameHolder, new SO3Waypoint());
    }

    public static FixedFrameSO3WaypointBasics newLinkedFixedFrameSO3WaypointBasics(final ReferenceFrameHolder referenceFrameHolder, final SO3WaypointBasics originalWaypoint) {
        return new FixedFrameSO3WaypointBasics(){
            private final FixedFrameQuaternionBasics orientation;
            private final FixedFrameVector3DBasics angularVelocity;
            {
                this.orientation = EuclidFrameFactories.newLinkedFixedFrameQuaternionBasics((ReferenceFrameHolder)referenceFrameHolder, (QuaternionBasics)originalWaypoint.getOrientation());
                this.angularVelocity = EuclidFrameFactories.newLinkedFixedFrameVector3DBasics((ReferenceFrameHolder)referenceFrameHolder, (Vector3DBasics)originalWaypoint.getAngularVelocity());
            }

            public ReferenceFrame getReferenceFrame() {
                return referenceFrameHolder.getReferenceFrame();
            }

            @Override
            public FixedFrameQuaternionBasics getOrientation() {
                return this.orientation;
            }

            @Override
            public FixedFrameVector3DBasics getAngularVelocity() {
                return this.angularVelocity;
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)this.getOrientation(), (Object)this.getAngularVelocity());
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof FrameSO3WaypointReadOnly) {
                    return this.equals((FrameSO3WaypointReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
            }
        };
    }
}

